/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.FigureCreator;
import de.renew.gui.FigureCreatorHolder;
import de.renew.gui.InscribableFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TextFigureCreator;
import de.renew.gui.TransitionFigure;
import de.renew.remote.ObjectAccessor;
import de.renew.util.TextToken;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FigureCreatorComposition
implements FigureCreator,
TextFigureCreator,
FigureCreatorHolder {
    public static Logger logger = Logger.getLogger(FigureCreatorComposition.class);
    private Vector<FigureCreator> _figureCreators = new Vector();
    private Vector<TextFigureCreator> _textFigureCreators = new Vector();

    @Override
    public void registerCreator(FigureCreator figureCreator) {
        this._figureCreators.add(figureCreator);
    }

    @Override
    public void registerCreator(TextFigureCreator textFigureCreator) {
        this._textFigureCreators.add(textFigureCreator);
    }

    @Override
    public void unregisterCreator(FigureCreator figureCreator) {
        this._figureCreators.remove(figureCreator);
    }

    @Override
    public void unregisterCreator(TextFigureCreator textFigureCreator) {
        this._figureCreators.remove(textFigureCreator);
    }

    @Override
    public boolean canCreateFigure(ObjectAccessor objectAccessor, boolean bl) throws RemoteException {
        for (FigureCreator figureCreator : this._figureCreators) {
            if (!figureCreator.canCreateFigure(objectAccessor, bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreateFigure(InscribableFigure inscribableFigure) {
        for (TextFigureCreator textFigureCreator : this._figureCreators) {
            if (!textFigureCreator.canCreateFigure(inscribableFigure)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCreateDefaultInscription(InscribableFigure inscribableFigure) {
        for (TextFigureCreator textFigureCreator : this._figureCreators) {
            if (!textFigureCreator.canCreateDefaultInscription(inscribableFigure)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TextFigure createTextFigure(InscribableFigure inscribableFigure) {
        Iterator<TextFigureCreator> iterator = this._textFigureCreators.iterator();
        TextFigure textFigure = null;
        while (iterator.hasNext()) {
            TextFigureCreator textFigureCreator = iterator.next();
            if (!textFigureCreator.canCreateFigure(inscribableFigure)) continue;
            logger.debug((Object)("FigureCreation: " + textFigureCreator + " creates a text figure for " + inscribableFigure));
            textFigure = textFigureCreator.createTextFigure(inscribableFigure);
            break;
        }
        if (textFigure == null) {
            logger.debug((Object)("FigureCreation: creating default text figure for " + inscribableFigure));
            return new CPNTextFigure();
        }
        return textFigure;
    }

    @Override
    public String getDefaultInscription(InscribableFigure inscribableFigure) {
        Iterator<TextFigureCreator> iterator = this._textFigureCreators.iterator();
        String string = null;
        while (iterator.hasNext()) {
            TextFigureCreator textFigureCreator = iterator.next();
            if (!textFigureCreator.canCreateDefaultInscription(inscribableFigure)) continue;
            logger.debug((Object)("FigureCreation: " + textFigureCreator + " creates an inscription for " + inscribableFigure));
            string = textFigureCreator.getDefaultInscription(inscribableFigure);
            break;
        }
        if (string == null) {
            logger.debug((Object)("FigureCreation: creating default inscription for " + inscribableFigure));
            if (inscribableFigure instanceof ArcConnection) {
                return "x";
            }
            if (inscribableFigure instanceof PlaceFigure) {
                return "[]";
            }
            if (inscribableFigure instanceof TransitionFigure) {
                return ":s()";
            }
            return "";
        }
        return string;
    }

    @Override
    public Figure getTokenFigure(ObjectAccessor objectAccessor, boolean bl) throws RemoteException {
        Iterator<FigureCreator> iterator = this._figureCreators.iterator();
        Figure figure = null;
        while (iterator.hasNext()) {
            FigureCreator figureCreator = iterator.next();
            if (!figureCreator.canCreateFigure(objectAccessor, bl)) continue;
            logger.debug((Object)(figureCreator + " creates a representation for this token."));
            figure = figureCreator.getTokenFigure(objectAccessor, bl);
            break;
        }
        if (figure == null) {
            logger.debug((Object)"creating default representation for this token.");
            return new TextFigure(FigureCreatorComposition.objectToString(objectAccessor), true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("got token figure for token " + objectAccessor + " --> result figure " + figure));
        }
        return figure;
    }

    public static String objectToString(ObjectAccessor objectAccessor) throws RemoteException {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectAccessor == null) {
            stringBuffer.append("null");
        } else if (objectAccessor.isInstanceOf(String.class)) {
            stringBuffer.append('\"').append(objectAccessor.asString()).append('\"');
        } else if (objectAccessor.isInstanceOf(TextToken.class)) {
            stringBuffer.append(objectAccessor.asTextToken().toTokenText());
        } else {
            stringBuffer.append(objectAccessor.asString());
        }
        return stringBuffer.toString();
    }
}

