/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.Breakpoint;
import de.renew.gui.BreakpointInscription;
import de.renew.gui.BreakpointManager;
import de.renew.net.Net;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.TransitionInstance;

class GlobalTransitionBreakpoint
implements Breakpoint {
    private BreakpointManager manager;
    private Transition transition;
    private Net net;
    private TransitionInstance hitInstance;
    private BreakpointInscription inscription = new BreakpointInscription(this);

    GlobalTransitionBreakpoint(BreakpointManager breakpointManager, Transition transition, Net net) {
        transition.add((TransitionInscription)this.inscription);
        this.manager = breakpointManager;
        this.transition = transition;
        this.net = net;
        this.hitInstance = null;
    }

    void hit(TransitionInstance transitionInstance) {
        this.hitInstance = transitionInstance;
        this.manager.stopSimulation();
        this.manager.informHitBreakpoint(this);
    }

    @Override
    public Object getTaggedElement() {
        return this.transition;
    }

    @Override
    public Object getHitElement() {
        return this.hitInstance;
    }

    @Override
    public Net getTaggedNet() {
        return this.net;
    }

    @Override
    public void release() {
        this.transition.remove((TransitionInscription)this.inscription);
        this.inscription = null;
        this.manager = null;
        this.transition = null;
        this.hitInstance = null;
    }

    public String toString() {
        return "Global breakpoint at transition " + this.transition;
    }
}

