/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.StatusDisplayer;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingLoader;
import de.renew.gui.ModeReplacement;
import de.renew.net.loading.Finder;
import de.renew.shadow.ShadowCompilerFactory;
import de.renew.shadow.ShadowNetSystem;
import de.renew.util.ClassSource;
import de.renew.util.StringUtil;
import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GuiFinder
extends Finder {
    public static Logger logger = Logger.getLogger(GuiFinder.class);
    CPNDrawingLoader loader;

    public GuiFinder(CPNDrawingLoader cPNDrawingLoader) {
        this.loader = cPNDrawingLoader;
    }

    public ShadowNetSystem findNetFile(String string, StringBuffer stringBuffer) {
        ShadowNetSystem shadowNetSystem = null;
        CPNDrawing cPNDrawing = this.getDrawingFromLoader(string);
        if (cPNDrawing == null) {
            cPNDrawing = this.getDrawingFromFile(stringBuffer);
        }
        if (cPNDrawing != null) {
            shadowNetSystem = this.compileDrawing(cPNDrawing);
        } else {
            logger.debug((Object)"GuiFinder: No drawing found.");
        }
        return shadowNetSystem;
    }

    public ShadowNetSystem findNetClasspathRel(String string, StringBuffer stringBuffer) {
        ShadowNetSystem shadowNetSystem = null;
        CPNDrawing cPNDrawing = this.getDrawingFromLoader(string);
        if (cPNDrawing == null) {
            cPNDrawing = this.getDrawingFromFileClasspathRel(stringBuffer);
        }
        if (cPNDrawing != null) {
            shadowNetSystem = this.compileDrawing(cPNDrawing);
        } else {
            logger.debug((Object)"GuiFinder: No drawing found.");
        }
        return shadowNetSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CPNDrawing getDrawingFromLoader(String string) {
        CPNDrawingLoader cPNDrawingLoader = this.loader;
        synchronized (cPNDrawingLoader) {
            Iterator<CPNDrawing> iterator = this.loader.loadedDrawings();
            while (iterator.hasNext()) {
                CPNDrawing cPNDrawing = iterator.next();
                String string2 = cPNDrawing.getName();
                if (!string.equals(string2)) continue;
                return cPNDrawing;
            }
        }
        return null;
    }

    CPNDrawing getDrawingFromFile(StringBuffer stringBuffer) {
        boolean bl;
        URL uRL = null;
        File file = null;
        String string = stringBuffer.toString();
        String string2 = string + ".rnw";
        logger.debug((Object)("looking for: " + string2));
        try {
            file = new File(string2);
            boolean bl2 = bl = !file.canRead();
            if (!bl) {
                try {
                    uRL = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    logger.error((Object)("Could not transform drawing filename to URL: " + malformedURLException.getMessage()));
                    bl = true;
                }
            }
            if (bl) {
                file = null;
            }
        }
        catch (Exception exception) {
            logger.error((Object)("GuiFinder: " + string2 + " caused " + exception));
            bl = true;
        }
        if (!bl) {
            assert (uRL != null) : "error should be set if url==null.";
            StatusRememberer statusRememberer = new StatusRememberer();
            final PositionedDrawing positionedDrawing = file != null ? DrawingFileHelper.loadPositionedDrawing((File)file, (StatusDisplayer)statusRememberer) : DrawingFileHelper.loadPositionedDrawing((URL)uRL, (StatusDisplayer)statusRememberer);
            Drawing drawing = null;
            if (positionedDrawing != null) {
                drawing = positionedDrawing.getDrawing();
            }
            if (drawing != null && drawing instanceof CPNDrawing) {
                final DrawApplication drawApplication = DrawPlugin.getGui();
                if (drawApplication != null) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        drawApplication.openDrawing(positionedDrawing);
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                drawApplication.openDrawing(positionedDrawing);
                            }
                        });
                    }
                }
                return (CPNDrawing)drawing;
            }
        }
        return null;
    }

    CPNDrawing getDrawingFromFileClasspathRel(StringBuffer stringBuffer) {
        StatusRememberer statusRememberer;
        Drawing drawing;
        boolean bl;
        String string = stringBuffer.toString();
        String string2 = string + ".rnw";
        logger.debug((Object)("looking for: " + string2));
        URL uRL = ClassSource.getClassLoader().getResource(StringUtil.convertToSlashes((String)string2));
        boolean bl2 = bl = uRL == null;
        if (!bl && (drawing = DrawingFileHelper.loadDrawing((URL)uRL, (StatusDisplayer)(statusRememberer = new StatusRememberer()))) != null && drawing instanceof CPNDrawing) {
            final IOHelper iOHelper = DrawPlugin.getCurrent().getIOHelper();
            if (iOHelper != null) {
                final URL uRL2 = uRL;
                if (SwingUtilities.isEventDispatchThread()) {
                    iOHelper.loadAndOpenDrawing(uRL2);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            iOHelper.loadAndOpenDrawing(uRL2);
                        }
                    });
                }
            }
            return (CPNDrawing)drawing;
        }
        return null;
    }

    private ShadowNetSystem compileDrawing(CPNDrawing cPNDrawing) {
        ShadowNetSystem shadowNetSystem = null;
        logger.debug((Object)("GuiFinder: Trying to build shadow for drawing " + cPNDrawing + "."));
        try {
            ShadowCompilerFactory shadowCompilerFactory = ModeReplacement.getInstance().getDefaultCompilerFactory();
            shadowNetSystem = new ShadowNetSystem(shadowCompilerFactory);
            cPNDrawing.buildShadow(shadowNetSystem);
            logger.debug((Object)"GuiFinder: Successful.");
            return shadowNetSystem;
        }
        catch (Exception exception) {
            logger.debug((Object)("GuiFinder: Problem " + exception + "."));
            return shadowNetSystem;
        }
    }

    private class StatusRememberer
    implements StatusDisplayer {
        private StatusRememberer() {
        }

        public void showStatus(String string) {
            logger.debug((Object)("GuiFinder: " + string));
        }
    }
}

