/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.Palette;
import CH.ifa.draw.util.PaletteListener;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import de.renew.gui.PaletteHolder;
import java.awt.Container;
import java.awt.Dialog;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class GuiPalettes
implements PaletteHolder {
    public static Logger logger = Logger.getLogger(GuiPalettes.class);
    private Vector<Palette> _palettes = new Vector();
    private GuiPlugin plugin;
    GuiEventDelegator _eventDelegator = new GuiEventDelegator();

    public GuiPalettes(GuiPlugin guiPlugin) {
        this.plugin = guiPlugin;
    }

    void notifyGuiOpen() {
        JPanel jPanel = this.plugin.getGui().getToolsPanel();
        for (Palette palette : this._palettes) {
            jPanel.add(palette.getComponent());
        }
        this.plugin.getGuiFrame().pack();
    }

    @Override
    public void addPalette(Palette palette) {
        logger.debug((Object)("-> GuiPlugin: registering palette " + palette));
        this._palettes.add(palette);
        if (this.plugin.isGuiPresent()) {
            JPanel jPanel = this.plugin.getGui().getToolsPanel();
            jPanel.add(palette.getComponent());
            this.plugin.getGuiFrame().pack();
        }
    }

    @Override
    public void removePalette(Palette palette) {
        logger.debug((Object)("-> GuiPlugin: removing palette " + palette));
        this._palettes.remove(palette);
        if (this.plugin.isGuiPresent()) {
            for (Container container = palette.getComponent().getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof Dialog)) continue;
                ((Dialog)container).dispose();
                break;
            }
            JPanel jPanel = this.plugin.getGui().getToolsPanel();
            jPanel.remove(palette.getComponent());
            jPanel.repaint();
        }
    }

    @Override
    public ToolButton createToolButton(Icon icon, Icon icon2, String string, Tool tool) {
        logger.debug((Object)("the delegator is " + this._eventDelegator));
        return new ToolButton((PaletteListener)this._eventDelegator, icon, icon2, string, tool);
    }

    @Override
    public ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton((PaletteListener)this._eventDelegator, string, string2, tool);
    }

    private class GuiEventDelegator
    implements PaletteListener {
        private GuiEventDelegator() {
        }

        public void paletteUserOver(ToolButton toolButton, boolean bl) {
            CPNApplication cPNApplication = GuiPlugin.getCurrent().getGui();
            if (cPNApplication != null) {
                cPNApplication.paletteUserOver(toolButton, bl);
            }
        }

        public void paletteUserSelected(ToolButton toolButton, boolean bl) {
            CPNApplication cPNApplication = GuiPlugin.getCurrent().getGui();
            if (cPNApplication != null) {
                cPNApplication.paletteUserSelected(toolButton, bl);
            }
        }
    }
}

