/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.CPNApplication;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.Server;
import java.awt.Dimension;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

class NetInstanceSelectionFrame
extends JFrame {
    public static Logger logger = Logger.getLogger(NetInstanceSelectionFrame.class);
    private static Hashtable<String, NetInstanceSelectionFrame> framesLookup = new Hashtable();
    private CPNApplication application;
    private Server server;
    private List netInstanceList;
    private NetInstanceAccessor[] netInstances;
    private String frameID;

    private NetInstanceSelectionFrame(CPNApplication cPNApplication, String string) {
        super(string);
        this.application = cPNApplication;
    }

    static synchronized void open(CPNApplication cPNApplication, Server server, String string, String string2) {
        String string3 = string + ":" + string2;
        NetInstanceSelectionFrame netInstanceSelectionFrame = framesLookup.get(string3);
        if (netInstanceSelectionFrame == null) {
            netInstanceSelectionFrame = new NetInstanceSelectionFrame(cPNApplication, "Net instances of " + string + ":" + string2);
            netInstanceSelectionFrame.frameID = string3;
            framesLookup.put(string3, netInstanceSelectionFrame);
            netInstanceSelectionFrame.server = server;
            netInstanceSelectionFrame.setup();
        }
        netInstanceSelectionFrame.toFront();
    }

    private void setup() {
        JButton jButton = new JButton("Open");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    NetInstanceSelectionFrame.this.openDrawing();
                }
                catch (RemoteException remoteException) {
                    logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                    JOptionPane.showMessageDialog(NetInstanceSelectionFrame.this, "A problem occurred: " + remoteException + "\n" + "See the console for details.", "Net instance selection frame", 0);
                }
            }
        });
        JButton jButton2 = new JButton("Refresh");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetInstanceSelectionFrame.this.update();
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(jButton);
        box.add(Box.createRigidArea(new Dimension(8, 0)));
        box.add(jButton2);
        Box box2 = Box.createVerticalBox();
        this.netInstanceList = new List();
        box2.add(this.netInstanceList);
        box2.add(Box.createRigidArea(new Dimension(0, 8)));
        box2.add(box);
        box2.add(Box.createRigidArea(new Dimension(0, 8)));
        this.getContentPane().add(box2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                framesLookup.remove(NetInstanceSelectionFrame.this.frameID);
            }
        });
        this.update();
        this.setLocation(20, 20);
        this.setSize(400, 200);
        this.setVisible(true);
    }

    public void openDrawing() throws RemoteException {
        int n = this.netInstanceList.getSelectedIndex();
        if (n >= 0 && n < this.netInstances.length) {
            this.application.openInstanceDrawing(this.netInstances[n]);
        }
    }

    private void update() {
        try {
            this.netInstances = this.server.getSimulator().getNetInstances();
            this.netInstanceList.removeAll();
            for (int i = 0; i < this.netInstances.length; ++i) {
                this.netInstanceList.add(this.netInstances[i].getNet().getName() + ":" + this.netInstances[i].getID());
            }
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            JOptionPane.showMessageDialog(this, "A problem occurred: " + remoteException + "\n" + "See the console for details.", "Net instance selection frame", 0);
        }
    }
}

