/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TokenBagFigure;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TokenCountsAccessor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PlaceInstanceFigure
extends AbstractFigure
implements InstanceFigure,
EventListener,
FigureChangeListener {
    public static Logger logger = Logger.getLogger(PlaceInstanceFigure.class);
    protected PlaceFigure placeFigure;
    protected PlaceInstanceAccessor placeInstance;
    protected RemoteEventForwarder forwarder;
    private boolean isMarked;
    protected int markingAppearance;
    protected CPNInstanceDrawing drawing;
    private AWTSynchronizedUpdate updateTask;

    public PlaceInstanceFigure(CPNInstanceDrawing cPNInstanceDrawing, PlaceFigure placeFigure, Hashtable<Serializable, ObjectAccessor> hashtable) {
        this.drawing = cPNInstanceDrawing;
        this.placeFigure = placeFigure;
        this.updateTask = new AWTSynchronizedUpdate((Runnable)new PlaceHighlightUpdateTask(this));
        this.initialize(hashtable);
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> hashtable) {
        if (hashtable.size() != 1) {
            logger.error((Object)("Error: There is not exactly one place instance for the figure " + this));
            return;
        }
        Enumeration<ObjectAccessor> enumeration = hashtable.elements();
        enumeration.hasMoreElements();
        this.placeInstance = (PlaceInstanceAccessor)enumeration.nextElement();
        this.placeFigure.addFigureChangeListener(this);
        this.markingAppearance = this.placeFigure.getMarkingAppearance();
        this.update();
        if (this.markingAppearance != 0) {
            this.addTokenBagFigure();
        }
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.placeInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
    }

    protected PlaceInstanceAccessor getInstance() {
        return this.placeInstance;
    }

    @Override
    public boolean isHighlighted() {
        return this.isMarked;
    }

    CPNInstanceDrawing drawing() {
        return this.drawing;
    }

    public void update() {
        this.updateTask.scheduleUpdate();
    }

    private void setHighlighted(boolean bl) {
        if (bl != this.isMarked) {
            this.isMarked = bl;
            this.invalidate();
            Figure figure = this.placeFigure.getHighlightFigure();
            if (figure != null) {
                Rectangle rectangle = figure.displayBox();
                rectangle.grow(5, 5);
                DrawingChangeEvent drawingChangeEvent = new DrawingChangeEvent((Drawing)this.drawing, rectangle);
                this.drawing.drawingInvalidated(drawingChangeEvent);
            }
            if (this.listener() != null) {
                this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
            }
        }
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return vector;
    }

    public Rectangle displayBox() {
        return this.placeFigure.displayBox();
    }

    protected void basicMoveBy(int n, int n2) {
    }

    public void draw(Graphics graphics) {
    }

    protected TokenBagFigure addTokenBagFigure() {
        TokenBagFigure tokenBagFigure = new TokenBagFigure((Drawing)this.drawing(), this, this.placeInstance, this.markingAppearance);
        this.drawing.add((Figure)tokenBagFigure);
        return tokenBagFigure;
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            try {
                ((CPNApplication)drawingView.editor()).openTokenBagDrawing(this.placeInstance);
                return true;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }
        if (this.getTokenBagFigure() == null) {
            drawingView.clearSelection();
            drawingView.addToSelection((Figure)this.addTokenBagFigure());
            return true;
        }
        return super.inspect(drawingView, bl);
    }

    public void setAttribute(String string, Object object) {
        if ("MarkingAppearance".equals(string)) {
            this.markingAppearance = (Integer)object;
            TokenBagFigure tokenBagFigure = this.getTokenBagFigure();
            if (this.markingAppearance == 0) {
                if (tokenBagFigure != null) {
                    this.drawing.remove((Figure)tokenBagFigure);
                }
            } else if (tokenBagFigure == null) {
                this.addTokenBagFigure();
            } else {
                tokenBagFigure.setMarkingAppearance(this.markingAppearance);
            }
        } else {
            super.setAttribute(string, object);
        }
    }

    public void release() {
        CPNInstanceDrawing cPNInstanceDrawing = this.drawing;
        if (cPNInstanceDrawing == null) {
            return;
        }
        if (this.drawing == null) {
            return;
        }
        if (this.placeInstance != null) {
            try {
                this.placeInstance.removeRemoteEventListener((RemoteEventListener)this.forwarder);
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            }
            this.placeInstance = null;
            this.drawing = null;
        }
        this.placeFigure.removeFigureChangeListener(this);
        super.release();
    }

    public TokenBagFigure getTokenBagFigure() {
        FigureEnumeration figureEnumeration = this.children();
        if (figureEnumeration.hasMoreElements()) {
            return (TokenBagFigure)((Object)figureEnumeration.nextElement());
        }
        return null;
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.changed();
    }

    public void figureHandlesChanged(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("PlaceInstanceFigure is not serializable!");
    }

    private static class PlaceHighlightUpdateTask
    implements Runnable {
        private PlaceInstanceFigure figure;

        public PlaceHighlightUpdateTask(PlaceInstanceFigure placeInstanceFigure) {
            this.figure = placeInstanceFigure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CPNInstanceDrawing cPNInstanceDrawing = this.figure.drawing();
            PlaceInstanceAccessor placeInstanceAccessor = this.figure.getInstance();
            if (cPNInstanceDrawing == null || placeInstanceAccessor == null) {
                return;
            }
            try {
                boolean bl;
                cPNInstanceDrawing.lock();
                if (this.figure.drawing() == null || this.figure.getInstance() == null) {
                    return;
                }
                try {
                    TokenCountsAccessor tokenCountsAccessor = placeInstanceAccessor.getTokenCounts();
                    bl = !tokenCountsAccessor.isEmpty();
                }
                catch (RemoteException remoteException) {
                    logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                    bl = false;
                }
                this.figure.setHighlighted(bl);
            }
            finally {
                cPNInstanceDrawing.unlock();
            }
        }
    }
}

