/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FigureException;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class SyntaxExceptionFrame
extends FigureChangeAdapter {
    private final JFrame frame;
    private final JButton selectButton;
    private final JTextArea textArea;
    private final CPNApplication editor;
    private FigureException e = null;

    SyntaxExceptionFrame(final CPNApplication cPNApplication) {
        this.editor = cPNApplication;
        this.frame = new JFrame("Renew: Syntax Error");
        this.frame.setIconImage(Toolkit.getDefaultToolkit().createImage(cPNApplication.getIconImage().getSource()));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.frame.getContentPane().add("Center", this.textArea);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.frame.getContentPane().add("South", jPanel);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SyntaxExceptionFrame.this.frame.dispose();
            }
        });
        this.selectButton = new JButton("Select");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuiPlugin.getCurrent().getGui().showDrawingViewContainer(((SyntaxExceptionFrame)SyntaxExceptionFrame.this).e.errorDrawing);
                if (SyntaxExceptionFrame.this.e != null && !cPNApplication.selectOffendingElements(SyntaxExceptionFrame.this.e)) {
                    SyntaxExceptionFrame.this.selectButton.setEnabled(false);
                }
            }
        });
        jPanel.add("1", jButton);
        jPanel.add("2", this.selectButton);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SyntaxExceptionFrame.this.dispose();
            }
        });
    }

    void displayException(FigureException figureException, boolean bl) {
        if (bl) {
            this.selectButton.setEnabled(this.editor.selectOffendingElements(figureException));
        } else {
            this.selectButton.setEnabled(true);
        }
        this.frame.setTitle(figureException.title);
        this.textArea.setText(figureException.getMessage());
        this.e = figureException;
        FigureEnumerator figureEnumerator = new FigureEnumerator(figureException.errorFigures);
        while (figureEnumerator.hasMoreElements()) {
            figureEnumerator.nextFigure().addFigureChangeListener((FigureChangeListener)this);
        }
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        this.dispose();
    }

    public void dispose() {
        if (this.e != null) {
            this.frame.dispose();
            FigureEnumerator figureEnumerator = new FigureEnumerator(this.e.errorFigures);
            while (figureEnumerator.hasMoreElements()) {
                figureEnumerator.nextFigure().removeFigureChangeListener((FigureChangeListener)this);
            }
            this.e = null;
        }
    }
}

