/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.TransitionFigure;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TransitionInstanceAccessor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TransitionInstanceFigure
extends AbstractFigure
implements InstanceFigure,
EventListener {
    public static Logger logger = Logger.getLogger(TransitionInstanceFigure.class);
    private TransitionFigure transitionFigure;
    private TransitionInstanceAccessor transitionInstance;
    private boolean afterglow = false;
    private Thread afterglowThread = null;
    private RemoteEventForwarder forwarder;
    protected CPNInstanceDrawing drawing;
    private AWTSynchronizedUpdate updateTask;

    public TransitionInstanceFigure(CPNInstanceDrawing cPNInstanceDrawing, TransitionFigure transitionFigure, Hashtable<Serializable, ObjectAccessor> hashtable) {
        this.drawing = cPNInstanceDrawing;
        this.transitionFigure = transitionFigure;
        this.initialize(hashtable);
        this.updateTask = new AWTSynchronizedUpdate(new Runnable(){

            @Override
            public void run() {
                TransitionInstanceFigure.this.executeUpdate();
            }
        });
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> hashtable) {
        if (hashtable.size() != 1) {
            logger.error((Object)("Error: There is not exactly one transition instance for the figure " + this));
            return;
        }
        this.transitionInstance = (TransitionInstanceAccessor)hashtable.elements().nextElement();
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.transitionInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
    }

    public boolean isFiring() {
        try {
            return this.transitionInstance.isFiring();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean isHighlighted() {
        return this.isFiring() || this.afterglow;
    }

    private void invalidateHighlight() {
        Figure figure = this.transitionFigure.getHighlightFigure();
        if (figure != null) {
            Rectangle rectangle = figure.displayBox();
            DrawingChangeEvent drawingChangeEvent = new DrawingChangeEvent((Drawing)this.drawing, rectangle);
            this.drawing.drawingInvalidated(drawingChangeEvent);
        }
    }

    public void update() {
        if (this.updateTask != null) {
            this.updateTask.scheduleUpdate();
        }
    }

    private void executeUpdate() {
        if (this.listener() != null) {
            if (this.afterglowThread != null && this.afterglowThread.isAlive()) {
                try {
                    this.afterglowThread.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.afterglow = true;
            this.invalidate();
            this.invalidateHighlight();
            this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)this));
            final TransitionInstanceFigure transitionInstanceFigure = this;
            this.afterglowThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            this.wait(100L);
                        }
                        TransitionInstanceFigure.this.afterglow = false;
                        TransitionInstanceFigure.this.invalidate();
                        TransitionInstanceFigure.this.invalidateHighlight();
                        TransitionInstanceFigure.this.listener().figureRequestUpdate(new FigureChangeEvent((Figure)transitionInstanceFigure));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            SimulationThreadPool.getCurrent().execute((Runnable)this.afterglowThread);
        }
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return vector;
    }

    public Rectangle displayBox() {
        return this.transitionFigure.displayBox();
    }

    protected void basicMoveBy(int n, int n2) {
    }

    public void draw(Graphics graphics) {
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            if (this.fire()) {
                String string;
                try {
                    string = this.transitionInstance.asString();
                }
                catch (RemoteException remoteException) {
                    string = remoteException.toString();
                }
                drawingView.editor().showStatus("Transition " + string + " fired.");
            } else {
                drawingView.editor().showStatus("No binding for this transition.");
            }
        } else {
            logger.debug((Object)("Searching bindings for " + this.transitionInstance + "..."));
            BindingSelectionFrame.open(this.transitionInstance, this.getSimulation());
        }
        return true;
    }

    protected CPNSimulation getSimulation() {
        return ModeReplacement.getInstance().getSimulation();
    }

    public boolean fire() {
        boolean bl;
        CPNSimulation cPNSimulation = this.getSimulation();
        cPNSimulation.getBreakpointManager().clearLog();
        try {
            bl = this.transitionInstance.fireOneBinding();
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            bl = false;
        }
        cPNSimulation.simulationRefresh();
        return bl;
    }

    public void release() {
        if (this.transitionInstance != null) {
            try {
                this.transitionInstance.removeRemoteEventListener((RemoteEventListener)this.forwarder);
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            }
            this.transitionInstance = null;
        }
        super.release();
    }

    protected TransitionInstanceAccessor getInstance() {
        return this.transitionInstance;
    }
}

