/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.converter;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.converter.NetConverterAbstract;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.SyntaxException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class RefNetConverter
extends NetConverterAbstract {
    public static Logger logger = Logger.getLogger(RefNetConverter.class);

    @Override
    public boolean isAttribute(String string) {
        boolean bl = false;
        if (string.equals("type") || string.equals("placeType")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isAnnotation(Element element) {
        boolean bl = false;
        String string = element.getNodeName();
        if (string.equals("initialMarking") || string.equals("name") || string.equals("inscription") || string.equals("annotation") || string.equals("label") || string.equals("guard") || string.equals("uplink") || string.equals("downlink") || string.equals("action") || string.equals("create") || string.equals("expression") || string.equals("declaration")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public TextFigure convertAnnotationToTextFigure(Element element) {
        TextFigure textFigure = new TextFigure();
        String string = element.getNodeName();
        textFigure = string.equals("initialMarking") ? new CPNTextFigure(1) : (string.equals("guard") ? new CPNTextFigure(1) : (string.equals("name") ? new CPNTextFigure(2) : (string.equals("inscription") ? new CPNTextFigure(1) : (string.equals("downlink") ? new CPNTextFigure(1) : (string.equals("uplink") ? new CPNTextFigure(1) : (string.equals("action") ? new CPNTextFigure(1) : (string.equals("create") ? new CPNTextFigure(1) : (string.equals("expression") ? new CPNTextFigure(1) : (string.equals("declaration") ? new DeclarationFigure() : (string.equals("placeType") ? new CPNTextFigure(1) : new CPNTextFigure()))))))))));
        return textFigure;
    }

    @Override
    public String convertAnnotationToPNML(CPNTextFigure cPNTextFigure) {
        String string = "";
        ShadowNet shadowNet = Converter.instance().getShadowNet();
        int n = cPNTextFigure.getType();
        switch (n) {
            case 2: {
                string = "name";
                break;
            }
            case 1: {
                string = "label";
                ParentFigure parentFigure = cPNTextFigure.parent();
                try {
                    if (parentFigure instanceof ArcConnection) {
                        string = shadowNet.checkArcInscription(cPNTextFigure.getText(), false);
                        break;
                    }
                    if (parentFigure instanceof PlaceFigure) {
                        string = shadowNet.checkPlaceInscription(cPNTextFigure.getText(), false);
                        break;
                    }
                    if (!(parentFigure instanceof TransitionFigure)) break;
                    string = shadowNet.checkTransitionInscription(cPNTextFigure.getText(), false);
                }
                catch (SyntaxException syntaxException) {
                    logger.error((Object)syntaxException.getMessage(), (Throwable)syntaxException);
                }
                break;
            }
            case 0: {
                string = "label";
                break;
            }
            default: {
                throw new RuntimeException("Unkown type");
            }
        }
        if (string == null) {
            string = "create";
        }
        return string;
    }

    public static boolean isNetParser(String string) {
        return string.equals("RefNet");
    }

    @Override
    public String convertRenewNameToAttributeName(String string, String string2) {
        String string3 = string;
        if (string2.equals("place")) {
            if (string.equals("type")) {
                string3 = "placeType";
            }
        } else if (string2.equals("transition")) {
            string3 = string;
        } else if (string2.equals("arc")) {
            string3 = "type";
        }
        return string3;
    }

    @Override
    public String convertRenewValueToAttributeValue(String string, String string2, String string3) {
        String string4 = string;
        if (string3.equals("place")) {
            string4 = string;
        } else if (string3.equals("transition")) {
            string4 = string;
        } else if (string3.equals("arc")) {
            string4 = string;
        }
        return string4;
    }

    @Override
    public boolean isInRenewAnnotation(Element element) {
        boolean bl = false;
        String string = element.getNodeName();
        if (string.equals("placeType")) {
            bl = true;
        }
        return bl;
    }
}

