/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import de.renew.gui.CPNDrawing;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.creator.NetCreator;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PNMLCreator {
    private static Document _doc;
    private PrintWriter _writer;

    protected Document getDoc() {
        return _doc;
    }

    protected void setDoc(Document document) {
        _doc = document;
    }

    protected PrintWriter writer() {
        return this._writer;
    }

    protected void setWriter(PrintWriter printWriter) {
        this._writer = printWriter;
    }

    protected void makeDoc() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        DocumentType documentType = documentBuilder.getDOMImplementation().createDocumentType("PNMLFile", null, null);
        String string = Converter.instance().getType();
        Document document = documentBuilder.getDOMImplementation().createDocument(string, "PNMLFile", documentType);
        this.setDoc(document);
    }

    public void write(OutputStream outputStream, CPNDrawing cPNDrawing) throws Exception {
        this.makeDoc();
        this.setWriter(new PrintWriter(outputStream));
        this.writeImpl(cPNDrawing);
        this.makeXML();
    }

    public void write(OutputStream outputStream, CPNDrawing[] cPNDrawingArray) throws Exception {
        this.makeDoc();
        this.setWriter(new PrintWriter(outputStream));
        for (int i = 0; i < cPNDrawingArray.length; ++i) {
            this.writeImpl(cPNDrawingArray[i]);
        }
        this.makeXML();
    }

    private void writeImpl(CPNDrawing cPNDrawing) {
        Element element = this.getDoc().getDocumentElement();
        NetCreator netCreator = new NetCreator();
        element.appendChild(netCreator.createElement(cPNDrawing));
    }

    private String tab(int n) {
        String string = "";
        for (int i = 1; i <= n; ++i) {
            string = string + "   ";
        }
        return string;
    }

    private void makeNode(Node node, int n) {
        if (node.getNodeType() == 1) {
            this.makeElementNode((Element)node, n);
        } else if (node.getNodeType() == 3) {
            this.makeTextNode((Text)node, n);
        }
    }

    private void makeElementNode(Element element, int n) {
        String string = element.getNodeName();
        NamedNodeMap namedNodeMap = element.getAttributes();
        this.writer().print(this.tab(n) + "<" + string);
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            this.writer().print(" " + attr.getName() + "=");
            this.writer().print(attr.getValue());
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            this.writer().println("/>");
        } else {
            this.writer().println(">");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                this.makeNode(node, n + 1);
            }
            this.writer().println(this.tab(n) + "</" + string + ">");
        }
    }

    private void makeTextNode(Text text, int n) {
        this.writer().print(this.tab(n) + "<" + "text" + ">");
        this.writer().print(text.getData());
        this.writer().println("</text>");
    }

    public void makeXML() {
        NodeList nodeList = this.getDoc().getDocumentElement().getChildNodes();
        String string = Converter.instance().getType();
        this.writer().println("<pnml xmlns=\"" + string + "\">");
        int n = 1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.makeNode(nodeList.item(i), n);
        }
        this.writer().println("</pnml>");
        this.writer().flush();
    }

    public static Element createElement(String string) {
        return _doc.createElement(string);
    }

    public static Text createTextNode(String string) {
        return _doc.createTextNode(string);
    }
}

