/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.GraphicParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AnnotationParser
extends ElementParser {
    private String _text;
    private int _offSetX = 0;
    private int _offSetY = 0;

    public AnnotationParser(Element element) {
        super(element);
    }

    protected String getText() {
        String string = "";
        if (this._text != null) {
            string = this._text;
        }
        return string;
    }

    protected void setText(String string) {
        this._text = string;
    }

    protected int offSetX() {
        return this._offSetX;
    }

    protected void setOffSetX(int n) {
        this._offSetX = n;
    }

    protected int offSetY() {
        return this._offSetY;
    }

    protected void setOffSetY(int n) {
        this._offSetY = n;
    }

    @Override
    protected void doParse() {
        Node node;
        NodeList nodeList = this.getElement().getElementsByTagName("text");
        if (nodeList.getLength() == 0) {
            nodeList = this.getElement().getElementsByTagName("value");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            node = (Text)element.getFirstChild();
            this.setText(node.getData());
        }
        NodeList nodeList2 = this.getElement().getElementsByTagName("graphics");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            node = (Element)nodeList2.item(i);
            GraphicParser graphicParser = new GraphicParser((Element)node);
            graphicParser.parse();
            this.setOffSetX(graphicParser.offsetX());
            this.setOffSetY(graphicParser.offsetY());
        }
    }

    public TextFigure getFigure() {
        NetConverter netConverter = Converter.instance().getNetConverter();
        TextFigure textFigure = netConverter.convertAnnotationToTextFigure(this.getElement());
        textFigure.setText(this.getText());
        textFigure.moveBy(this.offSetX(), this.offSetY());
        return textFigure;
    }
}

