/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import de.renew.gui.ArcConnection;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.pnml.parser.AttributeParser;
import de.renew.gui.pnml.parser.ObjectParser;
import java.awt.Color;
import java.awt.Point;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ArcParser
extends ObjectParser {
    private Map<String, Integer> _keys;
    private String _sourceString;
    private String _targetString;
    private Drawing _net;

    public ArcParser(Element element, Map<String, Integer> map, Drawing drawing) {
        super(element);
        this.setKeys(map);
        this.setNet(drawing);
    }

    protected Map<String, Integer> keys() {
        return this._keys;
    }

    protected void setKeys(Map<String, Integer> map) {
        this._keys = map;
    }

    protected String sourceString() {
        return this._sourceString;
    }

    protected void setSourceString(String string) {
        this._sourceString = string;
    }

    protected String targetString() {
        return this._targetString;
    }

    protected void setTargetString(String string) {
        this._targetString = string;
    }

    protected Drawing net() {
        return this._net;
    }

    protected void setNet(Drawing drawing) {
        this._net = drawing;
    }

    protected Color getLineColor() {
        Color color = null;
        if (this.getGraphic().hasLineColor()) {
            color = this.getGraphic().getLineColor();
        }
        return color;
    }

    protected String getLineStyle() {
        String string = "";
        if (this.getGraphic().hasLineStyle()) {
            string = this.getGraphic().getLineStyle();
        }
        return string;
    }

    @Override
    protected FigureWithID createObject() {
        ArcConnection arcConnection = new ArcConnection(1);
        for (AttributeParser attributeParser : this.getAttributes()) {
            if (!attributeParser.attributeName().equals("ArcType")) continue;
            String string = attributeParser.attributeValue();
            if (string.equals("inhibitor")) {
                arcConnection = new InhibitorConnection();
                continue;
            }
            if (string.equals("multi-ordinary")) {
                arcConnection = new DoubleArcConnection();
                continue;
            }
            if (string.equals("clear")) {
                arcConnection = new HollowDoubleArcConnection();
                continue;
            }
            if (string.equals("both")) {
                arcConnection = new ArcConnection(2);
                continue;
            }
            if (string.equals("test")) {
                arcConnection = new ArcConnection(0);
                continue;
            }
            arcConnection = new ArcConnection(1);
        }
        arcConnection.startPoint(0, 0);
        arcConnection.endPoint(0, 0);
        return arcConnection;
    }

    @Override
    protected void parseFigure() {
        String string = this.getElement().getAttribute("source");
        String string2 = this.getElement().getAttribute("target");
        NodeList nodeList = this.getElement().getElementsByTagName("toolspecific");
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (!element.getAttribute("tool").equals("renew")) continue;
                if (element.hasAttribute("source")) {
                    string = element.getAttribute("source");
                }
                if (!element.hasAttribute("target")) continue;
                string2 = element.getAttribute("target");
            }
        }
        this.setSourceString(string);
        this.setTargetString(string2);
    }

    protected Connector findConnector(Drawing drawing, int n) {
        Object object;
        Connector connector = null;
        FigureEnumeration figureEnumeration = drawing.figures();
        FigureWithID figureWithID = null;
        while (figureEnumeration.hasMoreElements() && (!((object = (Figure)figureEnumeration.nextElement()) instanceof FigureWithID) || (figureWithID = (FigureWithID)object).getID() != n)) {
        }
        if (figureWithID != null) {
            object = figureWithID.center();
            connector = figureWithID.connectorAt(object.x, object.y);
        }
        return connector;
    }

    @Override
    protected void doInitFigure() {
        ArcConnection arcConnection = (ArcConnection)this.figure();
        int n = this.keys().containsKey(this.sourceString()) ? this.keys().get(this.sourceString()) : Integer.parseInt(this.sourceString());
        int n2 = this.keys().containsKey(this.targetString()) ? this.keys().get(this.targetString()) : Integer.parseInt(this.targetString());
        arcConnection.connectStart(this.findConnector(this.net(), n));
        arcConnection.connectEnd(this.findConnector(this.net(), n2));
        arcConnection.updateConnection();
        super.doInitFigure();
    }

    @Override
    protected void initGraphic() {
        ArcConnection arcConnection = (ArcConnection)this.figure();
        int n = 1;
        Iterator<Point> iterator = this.getGraphic().positions();
        while (iterator.hasNext()) {
            Point point = iterator.next();
            arcConnection.insertPointAt(point, n++);
        }
        if (this.getLineColor() != null) {
            this.figure().setAttribute("FrameColor", (Object)this.getLineColor());
        }
        this.figure().setAttribute("LineStyle", (Object)this.getLineStyle());
    }
}

