/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import de.renew.gui.pnml.converter.GraphicConverter;
import de.renew.gui.pnml.parser.ElementParser;
import java.awt.Color;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GraphicParser
extends ElementParser {
    private NodeList positions;
    private NodeList dimension;
    private Element offSet;
    private Element fill;
    private Element line;

    public GraphicParser(Element element) {
        super(element);
    }

    @Override
    protected void doParse() {
        if (this.getElement() != null) {
            this.positions = this.getElement().getElementsByTagName("position");
            this.dimension = this.getElement().getElementsByTagName("dimension");
            NodeList nodeList = this.getElement().getElementsByTagName("offset");
            if (nodeList.getLength() > 0) {
                this.offSet = (Element)nodeList.item(0);
            }
            if ((nodeList = this.getElement().getElementsByTagName("fill")).getLength() > 0) {
                this.fill = (Element)nodeList.item(0);
            }
            if ((nodeList = this.getElement().getElementsByTagName("line")).getLength() > 0) {
                this.line = (Element)nodeList.item(0);
            }
        }
    }

    public Iterator<Point> positions() {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        if (this.positions != null) {
            for (int i = 0; i < this.positions.getLength(); ++i) {
                Element element = (Element)this.positions.item(i);
                int n = Integer.parseInt(element.getAttribute("x"));
                int n2 = Integer.parseInt(element.getAttribute("y"));
                linkedList.add(new Point(n, n2));
            }
        }
        return linkedList.iterator();
    }

    public boolean hasPosition() {
        boolean bl = false;
        if (this.positions != null && this.positions.getLength() > 0) {
            bl = true;
        }
        return bl;
    }

    public Point getDimension() {
        Point point = new Point();
        Element element = (Element)this.dimension.item(0);
        point.x = Integer.parseInt(element.getAttribute("x"));
        point.y = Integer.parseInt(element.getAttribute("y"));
        return point;
    }

    public boolean hasDimension() {
        boolean bl = false;
        if (this.dimension != null && this.dimension.getLength() > 0) {
            bl = true;
        }
        return bl;
    }

    public int offsetX() {
        int n = 0;
        if (this.offSet != null) {
            n = Integer.parseInt(this.offSet.getAttribute("x"));
        }
        return n;
    }

    public int offsetY() {
        int n = 0;
        if (this.offSet != null) {
            n = Integer.parseInt(this.offSet.getAttribute("y"));
        }
        return n;
    }

    public boolean hasFill() {
        return this.fill != null;
    }

    public Color getFill() {
        String string = this.fill.getAttribute("color");
        Color color = GraphicConverter.instance().parseCSS2Color(string);
        return color;
    }

    public boolean hasLine() {
        return this.line != null;
    }

    public boolean hasLineColor() {
        return this.line != null && !this.line.getAttribute("color").equals("");
    }

    public Color getLineColor() {
        String string = this.line.getAttribute("color");
        Color color = GraphicConverter.instance().parseCSS2Color(string);
        return color;
    }

    public boolean hasLineStyle() {
        return this.line != null && !this.line.getAttribute("style").equals("");
    }

    public String getLineStyle() {
        String string = this.line.getAttribute("style");
        return GraphicConverter.instance().parsePNMLLineStyle(string);
    }
}

