/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.framework.Drawing;
import de.renew.gui.pnml.parser.NetParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PNMLParser {
    public static Logger logger = Logger.getLogger(PNMLParser.class);
    private static PNMLParser _instance;

    public static PNMLParser instance() {
        if (_instance == null) {
            _instance = new PNMLParser();
        }
        return _instance;
    }

    private PNMLParser() {
    }

    public Drawing[] parse(InputStream inputStream) {
        Drawing[] drawingArray = null;
        Vector<Drawing> vector = new Vector<Drawing>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            NodeList nodeList = document.getElementsByTagName("net");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                NetParser netParser = new NetParser(element);
                netParser.parse();
                vector.add(netParser.getNet());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.error((Object)parserConfigurationException.getMessage(), (Throwable)parserConfigurationException);
        }
        catch (SAXException sAXException) {
            logger.error((Object)sAXException.getMessage(), (Throwable)sAXException);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        drawingArray = new Drawing[vector.size()];
        for (int i = 0; i < drawingArray.length; ++i) {
            drawingArray[i] = (Drawing)vector.get(i);
        }
        return drawingArray;
    }
}

