/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.xml;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.ParentFigure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DoubleArcConnection;
import de.renew.gui.HollowDoubleArcConnection;
import de.renew.gui.InhibitorConnection;
import de.renew.gui.xml.GraphicsParseState;
import de.renew.gui.xml.IgnoreElementState;
import de.renew.gui.xml.InscriptionState;
import de.renew.gui.xml.NetParseState;
import de.renew.gui.xml.NodeParseState;
import de.renew.gui.xml.ParseState;
import java.awt.Color;
import java.awt.Point;
import java.util.Hashtable;
import org.xml.sax.AttributeList;

class ArcParseState
implements ParseState {
    NetParseState env;
    ArcConnection figure;

    ArcParseState(NetParseState netParseState, AttributeList attributeList) {
        this.env = netParseState;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = attributeList.getLength();
        for (int i = 0; i < n; ++i) {
            hashtable.put(attributeList.getName(i), attributeList.getValue(i));
        }
        String string = (String)hashtable.get("type");
        boolean bl = true;
        if (string == null) {
            string = "ordinary";
        }
        if ("ordinary".equals(string)) {
            this.figure = new ArcConnection(1);
        } else if ("double".equals(string)) {
            this.figure = new ArcConnection(2);
        } else if ("test".equals(string)) {
            this.figure = new ArcConnection(0);
        } else if ("multi-ordinary".equals(string)) {
            this.figure = new DoubleArcConnection();
        } else if ("inhibitor".equals(string)) {
            this.figure = new InhibitorConnection();
        } else if ("clear".equals(string)) {
            this.figure = new HollowDoubleArcConnection();
        } else {
            bl = false;
            this.figure = new ArcConnection();
        }
        this.figure.startPoint(0, 0);
        this.figure.endPoint(0, 0);
        if (!bl) {
            this.attachErrorFigure("Unknown type: " + string);
        }
        this.figure.connectStart(this.findConnector((String)hashtable.get("source")));
        this.figure.connectEnd(this.findConnector((String)hashtable.get("target")));
        this.figure.updateConnection();
        for (int i = 0; i < n; ++i) {
            this.processAttribute(attributeList.getName(i), attributeList.getValue(i));
        }
        netParseState.drawing.add(this.figure);
    }

    Connector findConnector(String string) {
        int n = NodeParseState.parseID(string);
        FigureWithID figureWithID = this.env.drawing.getFigureWithID(n);
        Point point = figureWithID.center();
        return figureWithID.connectorAt(point.x, point.y);
    }

    void attachErrorFigure(String string) {
        TextFigure textFigure = new TextFigure();
        textFigure.setAttribute("FillColor", (Object)Color.red);
        textFigure.setText(string);
        textFigure.setParent((ParentFigure)this.figure);
        this.env.drawing.add((Figure)textFigure);
    }

    void processAttribute(String string, String string2) {
        if ("id".equals(string)) {
            this.figure.setID(NodeParseState.parseID(string2));
        } else if (!("source".equals(string) || "target".equals(string) || "type".equals(string))) {
            this.figure.setAttribute("XRNA" + string, string2);
        }
    }

    @Override
    public ParseState startElement(String string, AttributeList attributeList) {
        if ("annotation".equals(string)) {
            CPNTextFigure cPNTextFigure = new CPNTextFigure(1);
            cPNTextFigure.setParent(this.figure);
            return new InscriptionState(this, cPNTextFigure, this.env.drawing, attributeList, false);
        }
        if ("graphics".equals(string)) {
            return new GraphicsParseState(this, (AttributeFigure)this.figure);
        }
        return new IgnoreElementState(this);
    }

    @Override
    public ParseState endElement(String string) {
        return this.env;
    }

    @Override
    public ParseState characters(char[] cArray, int n, int n2) {
        return this;
    }
}

