/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MacaoExportFormat
extends ExportFormatAbstract {
    public static Logger logger = Logger.getLogger(MacaoExportFormat.class);

    public MacaoExportFormat() {
        super("Macao", (FileFilter)new NoFileFilter());
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File file) throws Exception {
        File file2 = null;
        logger.debug((Object)"writing in macao export format");
        if (drawing != null && file != null) {
            Serializable serializable;
            Object object;
            Object object2;
            Figure figure;
            file2 = file;
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
            printWriter.println("DB()");
            int n = 1;
            printWriter.println("CN(" + this.macaoString("place") + "," + ++n + ")");
            printWriter.println("CT(" + this.macaoString("marking") + "," + n + "," + this.macaoString("1") + ")");
            Hashtable<Figure, Integer> hashtable = new Hashtable<Figure, Integer>();
            FigureEnumeration figureEnumeration = drawing.figures();
            while (figureEnumeration.hasMoreElements()) {
                figure = figureEnumeration.nextFigure();
                if (!(figure instanceof PlaceFigure) && !(figure instanceof TransitionFigure)) continue;
                if (figure instanceof PlaceFigure) {
                    object2 = "place";
                    object = "domain";
                } else {
                    object2 = "transition";
                    object = null;
                }
                printWriter.println("CN(" + this.macaoString((String)object2) + "," + ++n + ")");
                serializable = figure.displayBox();
                printWriter.println("PO(-1," + n + "," + ((Rectangle)serializable).x + "," + ((Rectangle)serializable).y + "," + (((Rectangle)serializable).x + ((Rectangle)serializable).width) + "," + (((Rectangle)serializable).y + ((Rectangle)serializable).height) + ")");
                hashtable.put(figure, new Integer(n));
                if (!this.exportTextChildren(printWriter, (ParentFigure)figure, n, (String)object)) continue;
                Point point = figure.center();
                printWriter.println("PO(2," + point.x + "," + (point.y - 3 * ((Rectangle)serializable).height) + ")");
                printWriter.println("CA(" + this.macaoString("arc") + "," + (n + 1) + ",2," + n + ")");
                ++n;
            }
            figureEnumeration = drawing.figures();
            while (figureEnumeration.hasMoreElements()) {
                figure = figureEnumeration.nextFigure();
                if (!(figure instanceof ArcConnection)) continue;
                object2 = (ArcConnection)figure;
                object = (Integer)hashtable.get(object2.startFigure());
                serializable = (Integer)hashtable.get(object2.endFigure());
                boolean bl = ((ArcConnection)object2).getArcType() != 1;
                boolean bl2 = ((ArcConnection)object2).isReverse();
                if (bl || !bl2) {
                    this.exportArc(printWriter, (ArcConnection)object2, hashtable, (Integer)object, (Integer)serializable, ++n, false);
                }
                if (!bl && !bl2) continue;
                this.exportArc(printWriter, (ArcConnection)object2, hashtable, (Integer)serializable, (Integer)object, ++n, true);
            }
            printWriter.println("FB()");
            printWriter.close();
        }
        assert (file2 != null) : "Failure in EPSExportFormat: result == null";
        return file2;
    }

    public File export(Drawing[] drawingArray, File file) throws Exception {
        File file2 = null;
        assert (file2 != null) : "Failure in EPSExportFormat: result == null";
        return file2;
    }

    private String macaoString(String string) {
        return String.valueOf(string.length()) + ":" + string;
    }

    private boolean exportTextChildren(PrintWriter printWriter, ParentFigure parentFigure, int n, String string) {
        boolean bl = false;
        FigureEnumeration figureEnumeration = parentFigure.children();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof CPNTextFigure)) continue;
            CPNTextFigure cPNTextFigure = (CPNTextFigure)figure;
            String string2 = cPNTextFigure.getText();
            String string3 = null;
            int n2 = cPNTextFigure.getType();
            if (n2 == 2) {
                string3 = "name";
            } else if (n2 == 1) {
                if (string2.startsWith(":new(")) {
                    bl = true;
                }
                string3 = string;
                string = null;
            }
            if (string3 == null || string2.length() <= 0) continue;
            if (string3.equals("valuation")) {
                string2 = "<" + string2 + ">";
            }
            printWriter.println("CT(" + this.macaoString(string3) + "," + n + "," + this.macaoString(string2) + ")");
            Point point = cPNTextFigure.getOrigin();
            printWriter.println("PT(" + n + "," + this.macaoString(string3) + "," + point.x + "," + point.y + ")");
        }
        return bl;
    }

    private void exportArc(PrintWriter printWriter, ArcConnection arcConnection, Hashtable<Figure, Integer> hashtable, Integer n, Integer n2, int n3, boolean bl) {
        printWriter.println("CA(" + this.macaoString("arc") + "," + ++n3 + "," + n + "," + n2 + ")");
        hashtable.put(arcConnection, new Integer(n3));
        int n4 = arcConnection.pointCount() - 1;
        for (int i = 1; i < n4; ++i) {
            Point point = arcConnection.pointAt(bl ? n4 - i : i);
            printWriter.println("PI(-1," + n3 + "," + (point.x - 3) + "," + (point.y - 3) + ",-1)");
        }
        this.exportTextChildren(printWriter, arcConnection, n3, "valuation");
        hashtable.put(arcConnection, new Integer(n3));
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean bl = false;
        if (drawing instanceof CPNDrawing) {
            bl = true;
        }
        return bl;
    }
}

