/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import de.renew.gui.CPNDrawing;
import de.renew.gui.pnml.PNMLFormat;
import de.renew.gui.pnml.converter.Converter;
import de.renew.io.PNMLFileFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;

public abstract class PNMLExportFormat
extends ExportFormatAbstract {
    private String _type;

    public PNMLExportFormat(String string) {
        super("PNML " + string, (FileFilter)((Object)new PNMLFileFilter()));
        this.setType(string);
    }

    protected void setType(String string) {
        this._type = string;
    }

    protected String getType() {
        return this._type;
    }

    public boolean canExportNto1() {
        return true;
    }

    public File export(Drawing drawing, File file) throws Exception {
        File file2 = null;
        if (drawing != null && file != null) {
            file2 = file;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            Converter.instance().setType(this.getType());
            PNMLFormat pNMLFormat = new PNMLFormat();
            pNMLFormat.write((OutputStream)fileOutputStream, (CPNDrawing)drawing);
        }
        assert (file2 != null) : "Failure in PNMLExportFormat: result == null";
        return file2;
    }

    public File export(Drawing[] drawingArray, File file) throws Exception {
        File file2 = null;
        if (drawingArray != null && file != null) {
            file2 = file;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            Converter.instance().setType(this.getType());
            PNMLFormat pNMLFormat = new PNMLFormat();
            CPNDrawing[] cPNDrawingArray = new CPNDrawing[drawingArray.length];
            for (int i = 0; i < cPNDrawingArray.length; ++i) {
                cPNDrawingArray[i] = (CPNDrawing)drawingArray[i];
            }
            pNMLFormat.write((OutputStream)fileOutputStream, cPNDrawingArray);
        }
        assert (file2 != null) : "Failure in PNMLExportFormat: result == null";
        return file2;
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean bl = false;
        if (drawing instanceof CPNDrawing) {
            bl = true;
        }
        return bl;
    }
}

