/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.LogStrategy;
import de.renew.plugin.PluginManager;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.xml.DOMConfigurator;

public class DefaultLogStrategy
implements LogStrategy {
    public static final String LOG_CONFIG_PROPERTY_NAME = "log4j.configuration";
    public static final String LOG_HOME_PROPERTY_NAME = "logs.home";
    public static final String LOG_HOME_DEFAULT_LOCATION = "renewlogs";
    public static final String LOG4J_PROPERTIES_FILE = "log4j.properties";
    public static final String LOG4J_XML_FILE = "log4j.xml";

    @Override
    public void configureLogging() {
        Object object;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        Object object2 = null;
        try {
            object = System.getProperty(LOG_CONFIG_PROPERTY_NAME);
            if (object != null) {
                if (((String)object).endsWith(".xml")) {
                    DOMConfigurator.configure((String)object);
                } else {
                    PropertyConfigurator.configure((String)object);
                }
                bl = true;
                object2 = object;
            }
        }
        catch (Exception exception) {
            vector.add("A error occured while configuring the logging framework using the configuration file given by the property log4j.configuration. The following exception was thrown: " + exception.toString());
        }
        if (!bl) {
            try {
                File file;
                object = PluginManager.getLoaderLocation();
                String string = ((URL)object).toExternalForm();
                string = string.substring(0, string.lastIndexOf("/"));
                if (System.getProperty(LOG_HOME_PROPERTY_NAME) == null) {
                    file = new File(System.getProperty("user.home") + File.separator + LOG_HOME_DEFAULT_LOCATION);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (!file.isDirectory()) {
                        file = file.getParentFile();
                    } else {
                        System.setProperty(LOG_HOME_PROPERTY_NAME, file.getAbsolutePath());
                    }
                }
                object = new URL(string + "/config/" + LOG4J_XML_FILE);
                file = new File(new URI(((URL)object).toExternalForm()));
                File file2 = new File(System.getProperty("user.home") + File.separator + "." + LOG4J_XML_FILE);
                if (file2.exists() && file2.isFile()) {
                    file = file2;
                }
                if (file.exists() && file.isFile()) {
                    try {
                        DOMConfigurator.configure((String)file.getAbsolutePath());
                        bl = true;
                        object2 = file.getAbsolutePath();
                    }
                    catch (Exception exception) {
                        vector.add("An error occured during the configuration of the logging framework using the xml configuration file in the default config directory of the renew distribution.Error was: " + exception.toString());
                    }
                }
                if (!bl) {
                    object = new URL(string + "/config/" + LOG4J_PROPERTIES_FILE);
                    file = new File(new URI(((URL)object).toExternalForm()));
                    file2 = new File(System.getProperty("user.home") + File.separator + "." + LOG4J_PROPERTIES_FILE);
                    StringBuffer stringBuffer = new StringBuffer();
                    Properties properties = new Properties();
                    boolean bl2 = false;
                    if (file.exists() && file.isFile()) {
                        properties.load(new FileInputStream(file));
                        stringBuffer.append(file.getAbsolutePath());
                        bl2 = true;
                    }
                    if (file2.exists() && file2.isFile()) {
                        properties.load(new FileInputStream(file2));
                        if (bl2) {
                            stringBuffer.append(" and ");
                        }
                        stringBuffer.append(file2.getAbsolutePath());
                        bl2 = true;
                    }
                    if (bl2) {
                        try {
                            PropertyConfigurator.configure((Properties)properties);
                            bl = true;
                            object2 = stringBuffer.toString();
                        }
                        catch (Exception exception) {
                            vector.add("An error occured during the configuration of the logging framework using the properties configuration file(s) " + stringBuffer.toString() + ". Error was: " + exception.toString());
                        }
                    }
                }
            }
            catch (Exception exception) {
                vector.add(exception.toString());
            }
            if (!bl) {
                object = new ConsoleAppender((Layout)new SimpleLayout());
                object.setThreshold((Priority)Level.INFO);
                BasicConfigurator.configure((Appender)object);
                vector.add("No log4j configuration file found, falling back to failsaife settings.");
                object2 = "failsafe settings";
            }
        }
        if (!vector.isEmpty()) {
            object = vector.iterator();
            while (object.hasNext()) {
                PluginManager.logger.error(object.next());
            }
        }
        if (PluginManager.logger.isDebugEnabled()) {
            PluginManager.logger.debug((Object)("Used " + object2 + " to configure Log4j."));
        }
    }
}

