/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.DependencyNotFulfilledException;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class DependencyCheckList<O> {
    private List<DependencyElement<O>> _fulfilledElements = new Vector<DependencyElement<O>>();
    private Collection<String> _provided = new HashSet<String>();
    private Collection<DependencyElement<O>> _unfulfilledElements = new Vector<DependencyElement<O>>();

    public synchronized void addElement(DependencyElement<O> dependencyElement) {
        if (((DependencyElement)dependencyElement)._requirements.isEmpty()) {
            this._fulfilledElements.add(0, dependencyElement);
            this._provided.addAll(((DependencyElement)dependencyElement)._provisions);
            this.checkUnfulfilled();
            return;
        }
        int n = this._fulfilledElements.size();
        Vector vector = new Vector(((DependencyElement)dependencyElement)._requirements);
        for (int i = 0; i < n; ++i) {
            DependencyElement<O> dependencyElement2 = this._fulfilledElements.get(i);
            vector.removeAll(((DependencyElement)dependencyElement2)._provisions);
            if (!vector.isEmpty()) continue;
            this._fulfilledElements.add(i + 1, dependencyElement);
            this._provided.addAll(((DependencyElement)dependencyElement)._provisions);
            this.checkUnfulfilled();
            return;
        }
        this._unfulfilledElements.add(dependencyElement);
    }

    public synchronized void removeElement(O o) throws DependencyNotFulfilledException {
        Vector<DependencyElement<O>> vector = new Vector<DependencyElement<O>>();
        for (int i = this._fulfilledElements.size() - 1; i >= 0; --i) {
            DependencyElement<O> dependencyElement = this._fulfilledElements.get(i);
            if (o.equals(((DependencyElement)dependencyElement)._contained)) {
                if (!vector.isEmpty()) {
                    Vector<DependencyElement> vector2 = new Vector<DependencyElement>();
                    for (DependencyElement dependencyElement2 : vector) {
                        if (!dependencyElement2.requiresAny(((DependencyElement)dependencyElement)._provisions)) continue;
                        vector2.add(dependencyElement2);
                    }
                    if (!vector2.isEmpty()) {
                        throw new DependencyNotFulfilledException("cannot remove " + o + ": other elements are dependent on it.", vector2);
                    }
                }
                this._fulfilledElements.remove(i);
                this._provided.removeAll(((DependencyElement)dependencyElement)._provisions);
                return;
            }
            vector.add(dependencyElement);
        }
    }

    public synchronized Collection<DependencyElement<O>> removeElementWithDependencies(O o) {
        DependencyElement<O> dependencyElement = null;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        Vector<DependencyElement<O>> vector = new Vector<DependencyElement<O>>(this._fulfilledElements.size());
        int n = 0;
        while (dependencyElement == null && n < this._fulfilledElements.size()) {
            DependencyElement<O> dependencyElement2 = this._fulfilledElements.get(n);
            if (o.equals(((DependencyElement)dependencyElement2)._contained)) {
                dependencyElement = dependencyElement2;
                continue;
            }
            hashSet.addAll(((DependencyElement)dependencyElement2)._provisions);
            ++n;
        }
        if (dependencyElement != null) {
            boolean bl;
            int n2 = n + 1;
            do {
                vector.clear();
                hashSet2.clear();
                hashSet2.addAll(((DependencyElement)dependencyElement)._provisions);
                hashSet2.removeAll(hashSet);
                boolean bl2 = bl = !hashSet2.isEmpty();
                if (!bl) break;
                for (n = n2; bl && n < this._fulfilledElements.size(); ++n) {
                    DependencyElement<O> dependencyElement3 = this._fulfilledElements.get(n);
                    if (dependencyElement3.requiresAny(hashSet2)) {
                        vector.add(dependencyElement3);
                        hashSet2.addAll(((DependencyElement)dependencyElement3)._provisions);
                        hashSet2.removeAll(hashSet);
                        continue;
                    }
                    hashSet.addAll(((DependencyElement)dependencyElement3)._provisions);
                    bl = !hashSet2.removeAll(((DependencyElement)dependencyElement3)._provisions);
                }
            } while (!bl);
            this._fulfilledElements.remove(dependencyElement);
            this._fulfilledElements.removeAll(vector);
            this._unfulfilledElements.addAll(vector);
        }
        return vector;
    }

    public synchronized List<DependencyElement<O>> getFulfilled() {
        return this._fulfilledElements;
    }

    public synchronized Collection<DependencyElement<O>> getUnfulfilled() {
        return this._unfulfilledElements;
    }

    public synchronized List<O> getFulfilledObjects() {
        Vector<Object> vector = new Vector<Object>();
        for (DependencyElement<O> dependencyElement : this.getFulfilled()) {
            vector.add(((DependencyElement)dependencyElement)._contained);
        }
        return vector;
    }

    protected synchronized void checkUnfulfilled() {
        DependencyElement<O> dependencyElement = null;
        Iterator<DependencyElement<O>> iterator = this._unfulfilledElements.iterator();
        while (iterator.hasNext()) {
            DependencyElement<O> dependencyElement2 = iterator.next();
            if (!this.dependencyFulfilled(dependencyElement2)) continue;
            dependencyElement = dependencyElement2;
            iterator.remove();
            break;
        }
        if (dependencyElement != null) {
            this.addElement(dependencyElement);
        }
    }

    public synchronized boolean dependencyFulfilled(DependencyElement<?> dependencyElement) {
        Vector vector = new Vector(((DependencyElement)dependencyElement)._requirements);
        vector.removeAll(this._provided);
        return vector.isEmpty();
    }

    public static <O> DependencyElement<O> createElement(O o, String[] stringArray, String[] stringArray2) {
        return new DependencyElement<O>(o, Arrays.asList(stringArray), Arrays.asList(stringArray2));
    }

    public static class DependencyElement<O> {
        private O _contained;
        private Set<String> _provisions;
        private Set<String> _requirements;

        public DependencyElement(O o, Collection<String> collection, Collection<String> collection2) {
            this._contained = o;
            this._provisions = new HashSet<String>(collection);
            this._requirements = new HashSet<String>(collection2);
        }

        public static DependencyElement<PluginProperties> create(PluginProperties pluginProperties) {
            return new DependencyElement<PluginProperties>(pluginProperties, pluginProperties.getProvisions(), pluginProperties.getRequirements());
        }

        public static DependencyElement<IPlugin> create(IPlugin iPlugin) {
            return new DependencyElement<IPlugin>(iPlugin, iPlugin.getProperties().getProvisions(), iPlugin.getProperties().getRequirements());
        }

        public boolean requiresAny(Collection<? extends String> collection) {
            for (String string : collection) {
                if (!this._requirements.contains(string)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this._contained + "; providing " + CollectionLister.toString(this._provisions) + "; requiring " + CollectionLister.toString(this._requirements);
        }
    }
}

