/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.PluginManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PropertyHelper {
    public static Logger logger = Logger.getLogger(PropertyHelper.class);

    public static int getIntProperty(Properties properties, String string) {
        return PropertyHelper.getIntProperty(properties, string, -1);
    }

    public static int getIntProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string, Integer.toString(n));
        int n2 = n;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn((Object)("Invalid value for int property: " + string + "=" + string2 + "(using default: " + n + ")."));
        }
        return n2;
    }

    public static boolean getBoolProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        if (string2.trim().equals("")) {
            return true;
        }
        return Boolean.valueOf(string2);
    }

    public static Collection<String> parseListString(String string, StringTokenizer stringTokenizer) {
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        try {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                vector.add(string2);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error((Object)("PluginLoader: " + arrayIndexOutOfBoundsException + " when parsing " + string + " as list!"));
        }
        return vector;
    }

    public static Collection<String> parseListString(String string) {
        return PropertyHelper.parseListString(string, new StringTokenizer(string, ","));
    }

    public static Collection<String> parsePathListString(String string) {
        return PropertyHelper.parseListString(string, new StringTokenizer(string, File.pathSeparator));
    }

    public static List<String> getListProperty(Properties properties, String string) {
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (bl) {
            String string2 = properties.getProperty(string + "_" + n);
            if (string2 == null) {
                bl = false;
                break;
            }
            vector.add(string2);
            ++n;
        }
        return vector;
    }

    public static Class<?> getClassProperty(Properties properties, String string, Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = null;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                clazz3 = Class.forName(string2, true, PluginManager.getInstance().getBottomClassLoader());
                if (!clazz.isAssignableFrom(clazz3)) {
                    logger.error((Object)("Property " + string + " is invalid, ignoring: " + clazz3.getName() + " is not a subtype of " + clazz.getName() + "."));
                    clazz3 = null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.error((Object)("Property " + string + " is invalid, ignoring: Class " + string2 + " not found."));
                clazz3 = null;
            }
        }
        if (clazz3 == null) {
            clazz3 = clazz2;
        }
        return clazz3;
    }

    public static Class<?> getClassProperty(Properties properties, String string, Class<?> clazz) {
        return PropertyHelper.getClassProperty(properties, string, clazz, null);
    }
}

