/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public class GetPropertyCommand
implements CLCommand {
    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        if (stringArray.length > 0) {
            if ("-a".equals(stringArray[0])) {
                this.showAllPropertyNames(printStream);
            } else if ("-A".equals(stringArray[0])) {
                this.showAllProperties(printStream);
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.getProperty(stringArray[i], printStream);
                }
            }
        }
    }

    private void showAllPropertyNames(PrintStream printStream) {
        ArrayList<String> arrayList = this.getPropertyNames();
        for (String string : arrayList) {
            printStream.append(string + "\n");
        }
    }

    private void showAllProperties(PrintStream printStream) {
        ArrayList<String> arrayList = this.getPropertyNames();
        for (String string : arrayList) {
            String[] stringArray = new String[]{string};
            this.execute(stringArray, printStream);
        }
    }

    private ArrayList<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
            PluginProperties pluginProperties = iPlugin.getProperties();
            Enumeration<Object> enumeration = pluginProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    protected void getProperty(String string, PrintStream printStream) {
        String string2 = PluginProperties.getUserProperties().getProperty(string);
        if (string2 != null) {
            printStream.println(string + " = " + string2 + " (global value of property)");
        }
        boolean bl = true;
        for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
            PluginProperties pluginProperties = iPlugin.getProperties();
            String string3 = pluginProperties.getProperty(string);
            if (pluginProperties.isKnownProperty(string)) {
                if (string3 == null) {
                    printStream.println("Property " + string + " is known to plugin " + iPlugin.getName() + ", but not set.");
                } else {
                    printStream.println(string + " = " + string3 + " (known property in plugin " + iPlugin.getName() + ")");
                }
                bl = false;
                continue;
            }
            if (string3 == string2 || string3 != null && string3.equals(string2)) continue;
            if (string3 == null) {
                printStream.println("Property " + string + " is not set locally in plugin " + iPlugin.getName() + ".");
            } else {
                printStream.println(string + " = " + string3 + " (local value in plugin " + iPlugin.getName() + ")");
            }
            bl = false;
        }
        if (string2 == null && bl) {
            printStream.println("Property " + string + " is not set.");
        }
    }

    @Override
    public String getDescription() {
        return "Returns the value of the given PluginProperty. Options: [-a| -A] for a listing of all known property names / properties.";
    }
}

