/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ScriptCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(ScriptCommand.class);

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        if (stringArray.length > 1) {
            printStream.println("ScriptCommand: more than one parameter given: using only " + stringArray[0]);
        }
        Collection<String> collection = this.readFile(stringArray[0], printStream);
        Collection<CommandArgumentTuple> collection2 = this.createCommands(collection, printStream);
        Iterator<CommandArgumentTuple> iterator = collection2.iterator();
        while (iterator.hasNext()) {
            try {
                CommandArgumentTuple commandArgumentTuple = iterator.next();
                commandArgumentTuple.execute(printStream);
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)("PluginManager.PromptThread: an exeption occurred: " + runtimeException));
                logger.error((Object)runtimeException.getMessage(), (Throwable)runtimeException);
            }
        }
    }

    @Override
    public String getDescription() {
        return "reads an input file and interprets every line as a PluginManager command";
    }

    private Collection<String> readFile(String string, PrintStream printStream) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        String string2 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while (string2 != null) {
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                vector.add(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            printStream.println("ScriptCommand: file " + string + " not found.");
        }
        catch (IOException iOException) {
            logger.error((Object)("ScriptCommand: exception when reading " + string + ": " + iOException));
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        return vector;
    }

    private Collection<CommandArgumentTuple> createCommands(Collection<String> collection, PrintStream printStream) {
        Map<String, CLCommand> map = PluginManager.getInstance().getCLCommands();
        Vector<CommandArgumentTuple> vector = new Vector<CommandArgumentTuple>();
        for (String string : collection) {
            String[] stringArray = this.splitString(string);
            if (stringArray.length == 0 || stringArray[0].trim().startsWith("#")) continue;
            CLCommand cLCommand = map.get(stringArray[0]);
            if (cLCommand == null) {
                printStream.println("ScriptCommand: unknown command: " + stringArray[0]);
                continue;
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray[i + 1];
            }
            CommandArgumentTuple commandArgumentTuple = new CommandArgumentTuple(cLCommand, stringArray2);
            vector.add(commandArgumentTuple);
        }
        return vector;
    }

    private String[] splitString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private class CommandArgumentTuple {
        private CLCommand _command;
        private String[] _arguments;

        public CommandArgumentTuple(CLCommand cLCommand, String[] stringArray) {
            this._command = cLCommand;
            this._arguments = stringArray;
        }

        public void execute(PrintStream printStream) {
            this._command.execute(this._arguments, printStream);
        }
    }
}

