/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SetPropertyCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(SetPropertyCommand.class);

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.setProperty(stringArray[i], printStream);
        }
    }

    protected void setProperty(String string, PrintStream printStream) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = null;
        if (!stringTokenizer.hasMoreTokens()) {
            printStream.println("Usage: set property=value [property=value ...]");
            printStream.println("       Don't use spaces around the = sign!");
            return;
        }
        String string3 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            printStream.println("SetPropertyCommand: no argument given for variable " + string + ", it becomes unset.");
        } else {
            while (stringTokenizer.hasMoreTokens()) {
                if (string2 == null) {
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                string2 = string2 + "=" + stringTokenizer.nextToken();
            }
        }
        PluginProperties pluginProperties = PluginProperties.getUserProperties();
        if (string2 == null) {
            pluginProperties.remove(string3);
            for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
                PluginProperties pluginProperties2 = iPlugin.getProperties();
                pluginProperties2.remove(string3);
            }
        } else {
            pluginProperties.setProperty(string3, string2);
            for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
                PluginProperties pluginProperties3 = iPlugin.getProperties();
                pluginProperties3.setProperty(string3, string2);
            }
        }
    }

    @Override
    public String getDescription() {
        return "sets a system property (syntax key=value)";
    }
}

