/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UnloadCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(UnloadCommand.class);

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        if (stringArray.length == 1 && ("h".equals(stringArray[0]) || "-h".equals(stringArray[0]) || "--help".equals(stringArray[0]) || "--h".equals(stringArray[0]) || "-help".equals(stringArray[0]))) {
            printStream.println("usage: unload [-v | -r | -m] <PluginName>\nDescription: \nuse parameter -v to see a list of all dependent plug-ins\nuse parameter -r to unload all dependent plug-ins recursivly\nuse parameter -m to remove given plug-ins iff there are no dependors and\n\t\t at least one further plug-in which provides the same service (EXPERIMENTAL!!!)");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-v")) {
                bl = true;
                arrayList.add(new Integer(i));
                continue;
            }
            if (stringArray[i].equals("-r")) {
                bl2 = true;
                arrayList.add(new Integer(i));
                continue;
            }
            if (!stringArray[i].equals("-m")) continue;
            bl3 = true;
            arrayList.add(new Integer(i));
        }
        String string = this.mergeArgs(stringArray, arrayList);
        if (string == null || string.trim().length() == 0) {
            printStream.println("UnloadCommand: please set name of plug-in!");
            return;
        }
        IPlugin iPlugin = PluginManager.getInstance().getPluginByName(string);
        if (iPlugin == null) {
            printStream.println("UnloadCommand: did not find plug-in with name " + string);
            return;
        }
        try {
            Map<String, Collection<IPlugin>> map = this.checkDependencies(iPlugin, bl3);
            Set<Map.Entry<String, Collection<IPlugin>>> set = map.entrySet();
            if (set.isEmpty()) {
                PluginManager.getInstance().stop(iPlugin);
                printStream.println("Plug-in " + iPlugin + " successfully removed.");
            } else if (bl2) {
                List<IPlugin> list = this.getDependers(iPlugin, bl3);
                printStream.println("recursively unloading " + CollectionLister.toString(list));
                PluginManager.getInstance().stop(list);
                printStream.println("Dependent plug-ins \n(" + list + ")\n successfully removed.");
                printStream.println("Plug-in " + iPlugin + " successfully removed.");
            } else {
                printStream.println("UnloadCommand: could not unload " + iPlugin + ": there are plug-ins depending on it.");
                if (bl) {
                    for (Map.Entry<String, Collection<IPlugin>> entry : set) {
                        printStream.print(entry.getKey() + ":\t");
                        printStream.println(CollectionLister.toString(entry.getValue()));
                    }
                } else {
                    printStream.println("Use \"unload -v <PluginName>\" to see a list.");
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            printStream.println("cleanup canceled.");
        }
        catch (Exception exception) {
            printStream.println("cleanup canceled: " + exception + "; " + exception.getMessage());
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private String mergeArgs(String[] stringArray, ArrayList<Integer> arrayList) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (arrayList.contains(new Integer(i))) continue;
            if (!"".equals(string)) {
                string = string + " ";
            }
            string = string + stringArray[i];
        }
        return string;
    }

    private Map<String, Collection<IPlugin>> checkDependencies(IPlugin iPlugin, boolean bl) {
        Collection<String> collection = iPlugin.getProperties().getProvisions();
        HashMap<String, Collection<IPlugin>> hashMap = new HashMap<String, Collection<IPlugin>>();
        if (collection != null) {
            Iterator<String> iterator = collection.iterator();
            while (iterator != null && iterator.hasNext()) {
                Object object;
                String string = iterator.next();
                boolean bl2 = false;
                Collection<IPlugin> collection2 = PluginManager.getInstance().getPluginsProviding(string);
                if (collection2 != null && bl) {
                    object = collection2.iterator();
                    while (object != null && object.hasNext()) {
                        IPlugin iPlugin2 = (IPlugin)object.next();
                        if (iPlugin2.getName().equals(iPlugin.getName())) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (bl2 || (object = this.getRequirers(string)).isEmpty()) continue;
                hashMap.put(string, (Collection<IPlugin>)object);
            }
        }
        return hashMap;
    }

    private List<IPlugin> getDependers(IPlugin iPlugin, boolean bl) {
        ArrayList<IPlugin> arrayList = new ArrayList<IPlugin>();
        arrayList.add(iPlugin);
        Map<String, Collection<IPlugin>> map = this.checkDependencies(iPlugin, bl);
        Collection<Collection<IPlugin>> collection = map.values();
        arrayList.addAll(this.getDependers(collection, bl));
        return arrayList;
    }

    private List<IPlugin> getDependers(Collection<?> collection, boolean bl) {
        ArrayList<IPlugin> arrayList = new ArrayList<IPlugin>();
        for (Object obj : collection) {
            List<IPlugin> list;
            Object object;
            if (obj instanceof Collection) {
                object = (Collection)obj;
                object.removeAll(arrayList);
                list = this.getDependers((Collection<?>)object, bl);
            } else {
                object = (IPlugin)obj;
                list = this.getDependers((IPlugin)object, bl);
            }
            arrayList.removeAll(list);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private Collection<IPlugin> getRequirers(String string) {
        ArrayList<IPlugin> arrayList = new ArrayList<IPlugin>();
        List<IPlugin> list = PluginManager.getInstance().getPlugins();
        for (IPlugin iPlugin : list) {
            Collection<String> collection = iPlugin.getProperties().getRequirements();
            if (!collection.contains(string)) continue;
            arrayList.add(iPlugin);
        }
        return arrayList;
    }

    @Override
    public String getDescription() {
        return "cleans up (deactivates) a plugin";
    }
}

