/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.DependencyCheckList;
import de.renew.plugin.DependencyNotFulfilledException;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.IExtendedProgressBar;
import de.renew.plugin.load.PluginLoader;
import de.renew.plugin.load.SimplePluginLoader;
import de.renew.plugin.locate.PluginLocationFinders;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PluginLoaderComposition
implements PluginLoader {
    public static Logger logger = Logger.getLogger(PluginLoaderComposition.class);
    private Collection<PluginLoader> _loaders = new Vector<PluginLoader>();
    private static IExtendedProgressBar progressBar = null;

    public static void setProgressBar(IExtendedProgressBar iExtendedProgressBar) {
        progressBar = iExtendedProgressBar;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<IPlugin> loadPlugins() {
        int n;
        logger.info((Object)"loading plugins...");
        DependencyCheckList<PluginProperties> dependencyCheckList = new DependencyCheckList<PluginProperties>();
        Collection<PluginProperties> collection = PluginLocationFinders.getInstance().findPluginLocations();
        Vector<IPlugin> vector = new Vector<IPlugin>();
        PluginProperties object = null;
        for (PluginProperties object2 : collection) {
            if (object2.getName().equals("Renew Splashscreen")) {
                object = object2;
                continue;
            }
            dependencyCheckList.addElement(DependencyCheckList.DependencyElement.create(object2));
        }
        List list = dependencyCheckList.getFulfilledObjects();
        for (PluginProperties pluginProperties : list) {
            logger.debug((Object)pluginProperties);
        }
        boolean bl = false;
        int n2 = object != null ? -1 : 0;
        PluginClassLoader pluginClassLoader = PluginManager.getInstance().getPluginClassLoader();
        URL[] uRLArray = new URL[]{};
        for (n = 0; n < list.size(); ++n) {
            PluginProperties pluginProperties = (PluginProperties)list.get(n);
            uRLArray = SimplePluginLoader.unifyURL(pluginProperties.getURL());
            for (int n4 = 0; n4 < uRLArray.length; ++n4) {
                pluginClassLoader.addURL(uRLArray[n4]);
            }
        }
        for (n = n2; n < list.size(); ++n) {
            if (progressBar != null) {
                void var6_9;
                void var12_19 = var6_9++;
                double d = n + 1;
                double exception = list.size();
                int linkageError = (int)(d / exception * 100.0);
                try {
                    progressBar.propertyChange(new PropertyChangeEvent(this, "progress", (int)var12_19, linkageError));
                }
                catch (Exception exception2) {
                    progressBar = null;
                }
            }
            PluginProperties pluginProperties = n == -1 ? object : (PluginProperties)list.get(n);
            if (PluginManager.getInstance().getPluginByName(pluginProperties.getName()) != null) {
                logger.warn((Object)("PluginLoader: A plugin with the name " + pluginProperties.getName() + " has already been loaded. Skipping " + pluginProperties.getURL()));
                continue;
            }
            URL uRL = pluginProperties.getURL();
            IPlugin iPlugin = null;
            for (PluginLoader pluginLoader : this._loaders) {
                try {
                    iPlugin = pluginLoader.loadPlugin(pluginProperties);
                    if (iPlugin == null) continue;
                    break;
                }
                catch (RuntimeException runtimeException) {
                    logger.error((Object)("failure to load plugin " + pluginProperties.getName() + " from " + uRL + ": " + runtimeException));
                    logger.debug((Object)runtimeException.toString(), (Throwable)runtimeException);
                }
                catch (LinkageError linkageError) {
                    logger.error((Object)("failure to load plugin " + pluginProperties.getName() + " from " + uRL + ": " + linkageError));
                    logger.debug((Object)linkageError.toString(), (Throwable)linkageError);
                }
            }
            if (iPlugin != null) {
                try {
                    PluginManager.getInstance().addPlugin(iPlugin);
                    if (progressBar != null) {
                        try {
                            progressBar.propertyChange(new PropertyChangeEvent(this, "pluginLoaded", null, iPlugin.getName()));
                        }
                        catch (Exception exception) {
                            progressBar = null;
                        }
                    }
                    vector.add(iPlugin);
                    continue;
                }
                catch (DependencyNotFulfilledException dependencyNotFulfilledException) {
                    assert (false) : "The PluginManager doubts our dependency check for " + iPlugin;
                    continue;
                }
            }
            logger.debug((Object)("PluginLoaderComposition: did not load plugin from " + pluginProperties));
            Collection<DependencyCheckList.DependencyElement<PluginProperties>> dependencyNotFulfilledException = dependencyCheckList.removeElementWithDependencies(pluginProperties);
            if (!dependencyNotFulfilledException.isEmpty()) {
                logger.debug((Object)"PluginLoaderComposition: recalculated dependencies.");
            }
            list = dependencyCheckList.getFulfilledObjects();
            --n;
        }
        Collection collection2 = dependencyCheckList.getUnfulfilled();
        if (!collection2.isEmpty()) {
            logger.warn((Object)"There are plugins with unfulfilled dependencies:");
            logger.warn((Object)CollectionLister.toString(collection2));
        }
        if (progressBar != null) {
            progressBar.close();
        }
        return vector;
    }

    public void addLoader(PluginLoader pluginLoader) {
        this._loaders.add(pluginLoader);
    }

    public void removeLoader(PluginLoader pluginLoader) {
        this._loaders.remove(pluginLoader);
    }

    @Override
    public IPlugin loadPlugin(PluginProperties pluginProperties) {
        IPlugin iPlugin = null;
        for (PluginLoader pluginLoader : this._loaders) {
            try {
                iPlugin = pluginLoader.loadPlugin(pluginProperties);
                if (iPlugin == null) continue;
                break;
            }
            catch (Exception exception) {
                logger.error((Object)("PluginLoaderComposition: " + exception + " occured when " + pluginLoader + " tried to load plugin from " + pluginProperties.getURL()));
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return iPlugin;
    }

    @Override
    public IPlugin loadPluginFromURL(URL uRL) {
        IPlugin iPlugin = null;
        PluginManager pluginManager = PluginManager.getInstance();
        PluginProperties pluginProperties = PluginLocationFinders.getInstance().checkPluginLocation(uRL);
        if (pluginProperties != null) {
            if (pluginManager.checkDependenciesFulfilled(pluginProperties)) {
                iPlugin = this.loadPlugin(pluginProperties);
            } else {
                logger.error((Object)("Dependencies are not fulfilled for plugin " + pluginProperties.getName() + " located at " + pluginProperties.getURL()));
            }
        } else {
            for (PluginLoader pluginLoader : this._loaders) {
                try {
                    iPlugin = pluginLoader.loadPluginFromURL(uRL);
                    if (iPlugin == null) continue;
                    break;
                }
                catch (Exception exception) {
                    logger.error((Object)("PluginLoaderComposition: " + exception + " occured when " + pluginLoader + " tried to load plugin from " + uRL));
                    logger.debug((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        if (iPlugin != null) {
            try {
                pluginManager.addPlugin(iPlugin);
            }
            catch (DependencyNotFulfilledException dependencyNotFulfilledException) {
                logger.error((Object)("Dependencies are not fulfilled for " + iPlugin + " loaded from " + uRL));
            }
        }
        return iPlugin;
    }
}

