/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.load;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginClassLoader;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.load.PluginLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class SimplePluginLoader
implements PluginLoader {
    public static Logger logger = Logger.getLogger(SimplePluginLoader.class);

    /*
     * WARNING - void declaration
     */
    @Override
    public IPlugin loadPlugin(PluginProperties pluginProperties) {
        void var7_12;
        String string;
        URL uRL = pluginProperties.getURL();
        logger.debug((Object)("SimplePluginLoader loading from " + pluginProperties.getURL()));
        URL[] uRLArray = SimplePluginLoader.unifyURL(uRL);
        PluginClassLoader pluginClassLoader = PluginManager.getInstance().getPluginClassLoader();
        String string2 = "ok.";
        HashSet<URL> hashSet = new HashSet<URL>();
        URL[] object = pluginClassLoader.getURLs();
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            URL uRL2 = object[i];
            hashSet.add(uRL2);
        }
        Object var7_8 = null;
        try {
            for (n = 0; n < uRLArray.length; ++n) {
                if (hashSet.contains(uRLArray[n])) continue;
                pluginClassLoader.addURL(uRLArray[n]);
            }
            string = pluginProperties.getProperty("mainClass");
            if (string != null) {
                logger.debug((Object)("* creating a " + string + " with cl " + pluginClassLoader));
                Class<?> clazz = pluginClassLoader.loadClass(string);
                if (clazz.getClassLoader() != pluginClassLoader) {
                    logger.warn((Object)("system classloader was used to load " + clazz + "; it was probably in your classpath."));
                    logger.warn((Object)"That might turn out as a problem.");
                }
                Class[] classArray = new Class[]{pluginProperties.getClass()};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{pluginProperties};
                IPlugin iPlugin = (IPlugin)constructor.newInstance(objectArray);
                logger.debug((Object)("SimplePluginLoader: instantiated " + iPlugin));
            } else {
                logger.debug((Object)"* no main class!");
                PluginAdapter pluginAdapter = new PluginAdapter(pluginProperties);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            string2 = throwable.toString();
        }
        catch (Exception exception) {
            string2 = exception.toString();
        }
        if (var7_12 == null) {
            string = pluginProperties.getName();
            if (string == null) {
                string = "from " + uRL;
            }
            logger.error((Object)("SimplePluginLoader: Could not load plugin " + string + ": " + string2));
        } else {
            logger.debug((Object)("SimplePluginLoader result: " + string2));
        }
        return var7_12;
    }

    @Override
    public IPlugin loadPluginFromURL(URL uRL) {
        PluginProperties pluginProperties = new PluginProperties(uRL);
        try {
            InputStream inputStream = PluginConfigFinder.getConfigInputStream(uRL);
            pluginProperties.load(inputStream);
            return this.loadPlugin(pluginProperties);
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("SimplePluginLoader.loadPluginFromURL: " + malformedURLException));
        }
        catch (IOException iOException) {
            logger.error((Object)("SimplePluginLoader.loadPluginFromURL: " + iOException));
        }
        return null;
    }

    public static URL[] getURLsfromDirectory(File file) {
        if (file == null) {
            return null;
        }
        if (file.getName().endsWith(".jar")) {
            try {
                Vector<URL> vector = new Vector<URL>();
                vector.add(file.toURI().toURL());
                String string = "jar:" + file.toURI().toURL() + "!/";
                JarFile jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().startsWith("libs/") || !jarEntry.getName().endsWith(".jar")) continue;
                    vector.add(new URL(string + jarEntry.getName()));
                }
                return vector.toArray(new URL[0]);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)("SimplePluginLoader: Could not convert to URL: " + file + " (" + malformedURLException.getMessage() + ")."));
            }
            catch (IOException iOException) {
                logger.error((Object)("Error while opening/reading jar file: " + file), (Throwable)iOException);
            }
        }
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        return SimplePluginLoader.getJarsRecursiveFromDir(file).toArray(new URL[0]);
    }

    public static URL[] unifyURL(URL uRL) {
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.warn((Object)("SimplePluginLoader: Unable to search for jar files in " + uRL + ": " + uRISyntaxException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warn((Object)("SimplePluginLoader: Unable to search for jar files in " + uRL + ": " + illegalArgumentException));
        }
        catch (NullPointerException nullPointerException) {
            logger.warn((Object)("SimplePluginLoader: Unable to search for jar files in " + uRL + ": " + nullPointerException));
        }
        URL[] uRLArray = SimplePluginLoader.getURLsfromDirectory(file);
        if (uRLArray == null || uRLArray.length == 0) {
            logger.warn((Object)("SimplePluginLoader: No jar found in " + uRL + ", resorting to given URL."));
            return new URL[]{uRL};
        }
        return uRLArray;
    }

    protected Collection<String> parseListString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
        try {
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                vector.add(string2);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error((Object)("PluginLoader: " + arrayIndexOutOfBoundsException + " when parsing " + string + " as list!"));
        }
        return vector;
    }

    private static Vector<URL> getJarsRecursiveFromDir(File file) {
        Vector<URL> vector = new Vector<URL>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                if (!fileArray[i].getName().endsWith(".jar")) continue;
                try {
                    vector.add(fileArray[i].toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    logger.debug((Object)("Can't convert file location to URL: " + malformedURLException.getMessage()), (Throwable)malformedURLException);
                }
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            vector.addAll(SimplePluginLoader.getJarsRecursiveFromDir(fileArray[i]));
        }
        return vector;
    }

    public static class PluginSourceFinder {
        public static URL getPluginSource(URL uRL) {
            return uRL;
        }
    }

    public static class PluginConfigFinder {
        public static InputStream getConfigInputStream(URL uRL) throws MalformedURLException, IOException {
            URL uRL2 = new URL(uRL, "plugin.cfg");
            InputStream inputStream = null;
            try {
                inputStream = uRL2.openStream();
            }
            catch (Exception exception) {
                String string = uRL.toExternalForm();
                int n = string.lastIndexOf(33);
                if (n > -1) {
                    string = string.substring(0, n) + "/plugin.cfg";
                    logger.debug((Object)("trying alternate URL for plugin.cfg: " + string));
                }
                uRL2 = new URL(string);
                inputStream = uRL2.openStream();
            }
            return inputStream;
        }
    }
}

