/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.locate.PluginFileFinder;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class PluginJarLocationFinder
extends PluginFileFinder {
    public static Logger logger = Logger.getLogger(PluginJarLocationFinder.class);

    public PluginJarLocationFinder(URL uRL) {
        super(uRL);
    }

    @Override
    protected File[] getPluginFiles(File file) {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String string = file.getName();
                return file.isFile() && string.endsWith(".jar");
            }
        });
        return fileArray;
    }

    @Override
    protected Collection<PluginProperties> getPluginConfigurations(File[] fileArray) {
        Vector<PluginProperties> vector = new Vector<PluginProperties>();
        for (int i = 0; i < fileArray.length; ++i) {
            PluginProperties pluginProperties = this.createPluginConfig(fileArray[i]);
            if (pluginProperties == null) continue;
            vector.add(pluginProperties);
        }
        return vector;
    }

    protected PluginProperties createPluginConfig(File file) {
        if (!file.exists()) {
            logger.debug((Object)("jar file " + file + " does not exist."));
            return null;
        }
        logger.debug((Object)("looking for plugin.cfg in jar file " + file + "..."));
        try {
            URL uRL = file.toURI().toURL();
            PluginProperties pluginProperties = null;
            JarFile jarFile = new JarFile(file);
            ZipEntry zipEntry = jarFile.getEntry("plugin.cfg");
            if (zipEntry != null) {
                InputStream inputStream = jarFile.getInputStream(zipEntry);
                pluginProperties = new PluginProperties(uRL, inputStream);
                logger.debug((Object)("zip entry " + zipEntry + " found in " + jarFile.getName()));
            } else {
                logger.debug((Object)("no zip entry found in " + jarFile.getName()));
            }
            return pluginProperties;
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("PluginJarLocationFinder: could not create URL from " + file));
        }
        catch (Exception exception) {
            logger.error((Object)("PluginJarLocationFinder: " + exception));
        }
        return null;
    }

    public static void main(String[] stringArray) {
        PluginProperties.getUserProperties().setProperty("debug", "false");
        PluginJarLocationFinder pluginJarLocationFinder = new PluginJarLocationFinder(null);
        Collection<PluginProperties> collection = pluginJarLocationFinder.findPluginLocations();
        System.out.println("found the following locations:");
        System.out.println(CollectionLister.toString(collection));
    }
}

