/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.net.NetElementID;
import de.renew.net.PlaceInstance;
import de.renew.net.event.PlaceEvent;
import de.renew.net.event.PlaceEventListener;
import de.renew.net.event.TokenEvent;
import de.renew.remote.MarkingAccessor;
import de.renew.remote.MarkingAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.PlaceAccessor;
import de.renew.remote.PlaceAccessorImpl;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TokenCountsAccessor;
import de.renew.remote.TokenCountsAccessorImpl;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class PlaceInstanceAccessorImpl
extends ObjectAccessorImpl
implements PlaceEventListener,
PlaceInstanceAccessor {
    public static Logger logger = Logger.getLogger(PlaceInstanceAccessorImpl.class);
    private Set<RemoteEventListener> listeners = Collections.synchronizedSet(new HashSet());

    public PlaceInstanceAccessorImpl(PlaceInstance placeInstance, SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(placeInstance, simulationEnvironment);
    }

    @Override
    public NetElementID getID() throws RemoteException {
        return ((PlaceInstance)this.object).getPlace().getID();
    }

    @Override
    public PlaceAccessor getPlace() throws RemoteException {
        return new PlaceAccessorImpl(((PlaceInstance)this.object).getPlace(), this.getEnvironment());
    }

    public PlaceInstance getPlaceInstance() {
        return (PlaceInstance)this.object;
    }

    @Override
    public NetInstanceAccessor getNetInstance() throws RemoteException {
        return new NetInstanceAccessorImpl(((PlaceInstance)this.object).getNetInstance(), this.getEnvironment());
    }

    @Override
    public MarkingAccessor getMarking() throws RemoteException {
        return new MarkingAccessorImpl((PlaceInstance)this.object, this.getEnvironment());
    }

    @Override
    public TokenCountsAccessor getTokenCounts() throws RemoteException {
        return new TokenCountsAccessorImpl((PlaceInstance)this.object);
    }

    @Override
    public void addSerializableToken(Serializable serializable) throws RemoteException {
    }

    @Override
    public void addRemoteEventListener(final RemoteEventListener remoteEventListener) throws RemoteException {
        final PlaceInstanceAccessorImpl placeInstanceAccessorImpl = this;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set set = PlaceInstanceAccessorImpl.this.listeners;
                synchronized (set) {
                    if (PlaceInstanceAccessorImpl.this.listeners.isEmpty()) {
                        ((PlaceInstance)PlaceInstanceAccessorImpl.this.object).addPlaceEventListener((PlaceEventListener)placeInstanceAccessorImpl);
                    }
                    PlaceInstanceAccessorImpl.this.listeners.add(remoteEventListener);
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    @Override
    public void removeRemoteEventListener(final RemoteEventListener remoteEventListener) throws RemoteException {
        final PlaceInstanceAccessorImpl placeInstanceAccessorImpl = this;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set set = PlaceInstanceAccessorImpl.this.listeners;
                synchronized (set) {
                    PlaceInstanceAccessorImpl.this.listeners.remove(remoteEventListener);
                    if (PlaceInstanceAccessorImpl.this.listeners.isEmpty()) {
                        ((PlaceInstance)PlaceInstanceAccessorImpl.this.object).removePlaceEventListener((PlaceEventListener)placeInstanceAccessorImpl);
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }

    public boolean wantSynchronousNotification() {
        return false;
    }

    public void markingChanged(PlaceEvent placeEvent) {
        this.fireRemoteEvent();
    }

    public void tokenAdded(TokenEvent tokenEvent) {
        this.fireRemoteEvent();
    }

    public void tokenRemoved(TokenEvent tokenEvent) {
        this.fireRemoteEvent();
    }

    public void tokenTested(TokenEvent tokenEvent) {
        this.fireRemoteEvent();
    }

    public void tokenUntested(TokenEvent tokenEvent) {
        this.fireRemoteEvent();
    }

    private void fireRemoteEvent() {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Set set = PlaceInstanceAccessorImpl.this.listeners;
                synchronized (set) {
                    for (RemoteEventListener remoteEventListener : PlaceInstanceAccessorImpl.this.listeners) {
                        try {
                            remoteEventListener.update();
                        }
                        catch (RemoteException remoteException) {
                            logger.error((Object)("PlaceInstanceAccessor: Remote event to " + remoteEventListener + " probably got lost due to " + remoteException));
                        }
                    }
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
    }
}

