/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorExtension;
import de.renew.plugin.PropertyHelper;
import de.renew.remote.Server;
import de.renew.remote.ServerImpl;
import de.renew.shadow.ShadowLookup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RemoteExtension
implements SimulatorExtension {
    public static Logger logger = Logger.getLogger(RemoteExtension.class);
    private SimulationEnvironment currentEnvironment = null;
    private Server currentServer = null;
    private String currentServerUrl = null;
    public static final String CLASS_PROP_NAME = "de.renew.remote.serverClass";
    public static final String ENABLE_PROP_NAME = "de.renew.remote.enable";
    public static final String NAME_PROP_NAME = "de.renew.remote.publicName";
    public static final Class<?> DEFAULT_SERVER_CLASS = ServerImpl.class;

    public void simulationSetup(SimulationEnvironment simulationEnvironment) {
        assert (this.currentEnvironment == null) : "The last simulation has not been cleaned up properly.";
        assert (this.currentServer == null) : "The last remote server has not been cleaned up properly.";
        assert (this.currentServerUrl == null) : "The last remote server has not been cleaned up properly.";
        this.currentEnvironment = simulationEnvironment;
        Properties properties = simulationEnvironment.getProperties();
        boolean bl = PropertyHelper.getBoolProperty((Properties)properties, (String)ENABLE_PROP_NAME);
        if (bl) {
            Class<ServerImpl> clazz = PropertyHelper.getClassProperty((Properties)properties, (String)CLASS_PROP_NAME, Server.class);
            String string = properties.getProperty(NAME_PROP_NAME);
            if (clazz == null) {
                clazz = ServerImpl.class;
            }
            if (string == null) {
                string = "default";
            }
            this.currentServer = this.createServer(clazz);
            if (this.currentServer != null) {
                properties.setProperty(NAME_PROP_NAME, string);
                properties.setProperty(CLASS_PROP_NAME, clazz.getName());
                properties.setProperty(ENABLE_PROP_NAME, "true");
                this.currentServerUrl = ServerImpl.bindServer(this.currentServer, string, true);
            }
        } else {
            properties.remove(NAME_PROP_NAME);
            properties.remove(CLASS_PROP_NAME);
            properties.setProperty(ENABLE_PROP_NAME, "false");
        }
    }

    private Server createServer(Class<?> clazz) {
        Server server = null;
        logger.debug((Object)("RemoteExtension: Using server class " + clazz.getName() + "..."));
        try {
            Constructor<?> constructor = clazz.getConstructor(SimulationEnvironment.class);
            server = (Server)constructor.newInstance(this.currentEnvironment);
            logger.debug((Object)"RemoteExtension: Created server.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error((Object)("RemoteExtension: Could not create remote server: " + noSuchMethodException));
        }
        catch (SecurityException securityException) {
            logger.error((Object)("RemoteExtension: Could not create remote server: " + securityException));
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error((Object)("RemoteExtension: Could not create remote server: " + illegalAccessException));
        }
        catch (InstantiationException instantiationException) {
            logger.error((Object)("RemoteExtension: Could not create remote server: " + instantiationException));
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error((Object)"RemoteExtension: Server initialisation failed: ");
            logger.error((Object)invocationTargetException.getTargetException().getMessage(), invocationTargetException.getTargetException());
        }
        return server;
    }

    public void simulationTerminated() {
        if (this.currentServerUrl != null) {
            ServerImpl.unbindServer(this.currentServerUrl);
            logger.debug((Object)"RemoteExtension: Server disconnected from registry.");
            this.currentServerUrl = null;
        }
        this.currentServer = null;
        this.currentEnvironment = null;
    }

    public void simulationTerminating() {
    }

    public void netsCompiled(ShadowLookup shadowLookup) {
    }
}

