/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulatorExtension;
import de.renew.application.SimulatorPlugin;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.PlaceInstance;
import de.renew.net.TransitionInstance;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessorImpl;
import de.renew.remote.RemoteExtension;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class RemotePlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(SimulatorPlugin.class);
    private static RemotePlugin _instance;

    public RemotePlugin(URL uRL) throws PluginException {
        super(uRL);
        this.setInstance();
        this.setup();
    }

    public RemotePlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
        this.setInstance();
        this.setup();
    }

    private void setup() {
        SimulatorPlugin.getCurrent().addExtension((SimulatorExtension)new RemoteExtension());
    }

    private void setInstance() {
        if (_instance == null) {
            _instance = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetInstanceAccessor wrapInstance(final NetInstance netInstance) throws NoSimulationException {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        SimulatorPlugin.lock.lock();
        try {
            Object object = simulatorPlugin.submitAndWait((Callable)new Callable<NetInstanceAccessor>(){

                @Override
                public NetInstanceAccessor call() throws NoSimulationException {
                    NetInstanceAccessorImpl netInstanceAccessorImpl = null;
                    try {
                        netInstanceAccessorImpl = netInstance == null ? null : new NetInstanceAccessorImpl(netInstance, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of net instance failed: " + remoteException));
                    }
                    return netInstanceAccessorImpl;
                }
            });
            if (object instanceof Future) {
                NetInstanceAccessor netInstanceAccessor = (NetInstanceAccessor)((Future)object).get();
                return netInstanceAccessor;
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaceInstanceAccessor wrapInstance(final PlaceInstance placeInstance) {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        SimulatorPlugin.lock.lock();
        try {
            Object object = simulatorPlugin.submitAndWait((Callable)new Callable<PlaceInstanceAccessor>(){

                @Override
                public PlaceInstanceAccessor call() throws NoSimulationException {
                    PlaceInstanceAccessorImpl placeInstanceAccessorImpl = null;
                    try {
                        placeInstanceAccessorImpl = placeInstance == null ? null : new PlaceInstanceAccessorImpl(placeInstance, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of place instance failed: " + remoteException));
                    }
                    return placeInstanceAccessorImpl;
                }
            });
            if (object instanceof Future) {
                PlaceInstanceAccessor placeInstanceAccessor = (PlaceInstanceAccessor)((Future)object).get();
                return placeInstanceAccessor;
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransitionInstanceAccessor wrapInstance(final TransitionInstance transitionInstance) {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        SimulatorPlugin.lock.lock();
        try {
            Object object = simulatorPlugin.submitAndWait((Callable)new Callable<TransitionInstanceAccessor>(){

                @Override
                public TransitionInstanceAccessor call() throws NoSimulationException {
                    TransitionInstanceAccessorImpl transitionInstanceAccessorImpl = null;
                    try {
                        transitionInstanceAccessorImpl = transitionInstance == null ? null : new TransitionInstanceAccessorImpl(transitionInstance, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of transition instance failed: " + remoteException));
                    }
                    return transitionInstanceAccessorImpl;
                }
            });
            if (object instanceof Future) {
                TransitionInstanceAccessor transitionInstanceAccessor = (TransitionInstanceAccessor)((Future)object).get();
                return transitionInstanceAccessor;
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetAccessor wrapNet(final Net net) {
        final SimulatorPlugin simulatorPlugin = SimulatorPlugin.getCurrent();
        SimulatorPlugin.lock.lock();
        try {
            Object object = simulatorPlugin.submitAndWait((Callable)new Callable<NetAccessor>(){

                @Override
                public NetAccessor call() throws NoSimulationException {
                    NetAccessorImpl netAccessorImpl = null;
                    try {
                        netAccessorImpl = net == null ? null : new NetAccessorImpl(net, simulatorPlugin.getCurrentEnvironment());
                    }
                    catch (RemoteException remoteException) {
                        logger.error((Object)("Wrapping of net failed: " + remoteException));
                    }
                    return netAccessorImpl;
                }
            });
            if (object instanceof Future) {
                NetAccessor netAccessor = (NetAccessor)((Future)object).get();
                return netAccessor;
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            SimulatorPlugin.lock.unlock();
        }
        return null;
    }

    public static RemotePlugin getInstance() {
        return _instance;
    }
}

