/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.DelayedField;
import de.renew.util.DelayedFieldOwner;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RenewObjectOutputStream
extends ObjectOutputStream {
    public static Logger logger = Logger.getLogger(RenewObjectOutputStream.class);
    protected static final String SECTIONLABEL = "Delayed:";
    private Vector<DelayedField> delayedObjects;
    private Stack<Object> objectTrace = new Stack();

    public RenewObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.delayedObjects = new Vector();
    }

    public void delayedWriteObject(Object object, DelayedFieldOwner delayedFieldOwner) {
        this.delayedObjects.addElement(new DelayedField(object, delayedFieldOwner));
    }

    public void writeDelayedObjects() throws IOException {
        this.beginDomain(SECTIONLABEL);
        super.writeObject(SECTIONLABEL);
        while (!this.delayedObjects.isEmpty()) {
            int n = this.delayedObjects.size();
            Enumeration<DelayedField> enumeration = this.delayedObjects.elements();
            this.delayedObjects = new Vector();
            super.writeInt(n);
            while (enumeration.hasMoreElements()) {
                DelayedField delayedField = enumeration.nextElement();
                super.writeObject(delayedField);
            }
        }
        super.writeInt(0);
        this.endDomain(SECTIONLABEL);
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeDelayedObjects();
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException("Exception occured while writing delayed objects on close: " + iOException);
        }
        finally {
            super.close();
        }
    }

    public void beginDomain(Object object) {
        this.objectTrace.push(object);
    }

    public void endDomain(Object object) {
        try {
            if (this.objectTrace.peek() == object) {
                this.objectTrace.pop();
            } else {
                logger.error((Object)("End domain by wrong owner requested by " + object));
                logger.error((Object)("Top of stack is " + this.objectTrace.peek()));
                logger.error((Object)("Owner resides " + this.objectTrace.search(object) + " from top of stack"));
            }
        }
        catch (EmptyStackException emptyStackException) {
            logger.error((Object)("End domain on empty stack requested by " + object));
        }
    }

    public Stack<Object> getDomainTrace() {
        return (Stack)this.objectTrace.clone();
    }
}

