/*
 * Decompiled with CFR 0.152.
 */
package de.renew.splashscreen;

import de.renew.plugin.load.IExtendedProgressBar;
import de.renew.splashscreen.ExtendedProgressBar;
import de.renew.splashscreen.ImagePanel;
import de.renew.splashscreen.SplashscreenPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.apache.log4j.Logger;

public class RenewSplashScreen
extends JPanel {
    private static final Logger logger = Logger.getLogger(RenewSplashScreen.class);
    private static final String splashBackground = "splashscreen.png";
    private static BufferedImage img = null;
    private static Dimension size = new Dimension(500, 500);
    private static JWindow splashScreen;
    private IExtendedProgressBar extendedProgressBar;
    private ImagePanel imgPanel;
    private static RenewSplashScreen renewSplashScreen;

    private RenewSplashScreen() {
        if (renewSplashScreen == null) {
            this.extendedProgressBar = ExtendedProgressBar.getInstance();
            renewSplashScreen = this;
        }
    }

    public static synchronized RenewSplashScreen getInstance() {
        if (renewSplashScreen == null) {
            try {
                renewSplashScreen = new RenewSplashScreen();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                logger.trace((Object)("Splash screen setup: Caught " + noClassDefFoundError));
                String string = noClassDefFoundError.getMessage();
                if (string != null && string.contains("sun.awt.X11GraphicsEnvironment")) {
                    logger.info((Object)("Splash screen deactivated by NoClassDefFoundError: " + noClassDefFoundError.getMessage() + "\nProbably the DISPLAY variable points to an inaccessible X server." + "\nPlease check the variable and the X server configuration."));
                }
                throw noClassDefFoundError;
            }
        }
        return renewSplashScreen;
    }

    public boolean showSplashScreen(URL uRL) {
        try {
            logger.debug((Object)"Setting up splash screen.");
            this.createBackgroundImage();
            splashScreen = new JWindow();
            this.setDisplayLocation();
            splashScreen.setSize(size);
            splashScreen.setLayout(null);
            splashScreen.setBackground(Color.WHITE);
            Container container = splashScreen.getContentPane();
            container.setBackground(Color.WHITE);
            this.extendedProgressBar.setBounds(RenewSplashScreen.size.width / 6, 150, (int)((double)RenewSplashScreen.size.width / 1.5), 300);
            container.add((Component)this.extendedProgressBar);
            container.add(this.imgPanel);
            splashScreen.validate();
            splashScreen.setVisible(true);
            splashScreen.toFront();
            return true;
        }
        catch (HeadlessException headlessException) {
            logger.info((Object)("Splash screen deactivated by HeadlessException: " + headlessException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            logger.warn((Object)("Exception during splash screen setup: " + exception), (Throwable)exception);
            return false;
        }
    }

    private void setDisplayLocation() throws NullPointerException {
        Object object;
        int n = 0;
        int n2 = 0;
        try {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            object = graphicsEnvironment.getScreenDevices();
            DisplayMode displayMode = ((GraphicsDevice)object[0]).getDisplayMode();
            n = displayMode.getWidth();
            n2 = displayMode.getHeight();
        }
        catch (Exception exception) {
            object = Toolkit.getDefaultToolkit().getScreenSize();
            n = ((Dimension)object).getSize().width;
            n2 = ((Dimension)object).getSize().height;
        }
        if (n2 <= 0 || n <= 0) {
            throw new NullPointerException("Could not determine display location.");
        }
        int n3 = RenewSplashScreen.size.width / 2;
        int n4 = RenewSplashScreen.size.height / 2;
        splashScreen.setLocation(n / 2 - n3, n2 / 2 - n4);
    }

    public void closeSplashScreen() {
        if (splashScreen != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)"Splash screen progress update delay interrupted.  Skipping...");
            }
            logger.debug((Object)"Closing splash screen.");
            splashScreen.dispose();
        }
    }

    private void createBackgroundImage() throws IOException, URISyntaxException {
        InputStream inputStream = this.getInputStreamFromJarForFile(SplashscreenPlugin.getInstance().getProperties().getURL(), splashBackground);
        if (inputStream != null) {
            img = ImageIO.read(inputStream);
            size.setSize(img.getWidth() + 20, img.getHeight() + 20);
        }
        this.imgPanel = new ImagePanel(img, size);
    }

    private InputStream getInputStreamFromJarForFile(URL uRL, String string) throws IOException, URISyntaxException {
        logger.debug((Object)("Loading " + string + " from " + uRL));
        JarFile jarFile = new JarFile(new File(uRL.toURI()));
        ZipEntry zipEntry = jarFile.getEntry(string);
        return zipEntry != null ? jarFile.getInputStream(zipEntry) : null;
    }
}

