/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism;

import de.renew.formalism.CompilerStore;
import de.renew.formalism.FormalismChangeListener;
import de.renew.formalism.bool.BoolNetCompiler;
import de.renew.formalism.java.JavaNetCompiler;
import de.renew.formalism.pt.PTNetCompiler;
import de.renew.plugin.CollectionLister;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import de.renew.shadow.ShadowCompilerFactory;
import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

public class FormalismPlugin
extends PluginAdapter {
    private String _chosenCompiler;
    private String _activeCompiler;
    private Vector<FormalismChangeListener> _listeners = new Vector();
    CompilerStore _store;
    public static final String BOOL_COMPILER = "Bool Net Compiler";
    public static final String JAVA_COMPILER = "Java Net Compiler";
    public static final String TIMED_COMPILER = "Timed Java Compiler";
    public static final String PT_COMPILER = "P/T Net Compiler";
    public static final String COMPILER_PROP_NAME = "renew.compiler";

    public FormalismPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public FormalismPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public void init() {
        this._store = new CompilerStore();
        this._chosenCompiler = this._properties.getProperty(COMPILER_PROP_NAME, JAVA_COMPILER);
        PluginManager.getInstance().addCLCommand("listFormalisms", (CLCommand)new ListFormalismsCommand());
        PluginManager.getInstance().addCLCommand("setFormalism", (CLCommand)new SetFormalismCommand());
        this.addCompilerFactory(BOOL_COMPILER, new BoolNetCompiler());
        JavaNetCompiler javaNetCompiler = new JavaNetCompiler();
        this.addCompilerFactory(JAVA_COMPILER, javaNetCompiler);
        this.addCompilerFactory(TIMED_COMPILER, new JavaNetCompiler(true, true, true));
        this.addCompilerFactory(PT_COMPILER, new PTNetCompiler());
        this.setCompiler(this._chosenCompiler);
    }

    public void setCompiler(String string) {
        logger.debug((Object)("FormalismPlugin setting compiler " + string));
        if (string == null) {
            return;
        }
        if (!this._store.containsKey(string)) {
            this._chosenCompiler = string;
            return;
        }
        if (string.equals(this._activeCompiler)) {
            return;
        }
        this._activeCompiler = string;
        this.getProperties().setProperty(COMPILER_PROP_NAME, this._activeCompiler);
        this.notifyListeners(string, 2);
    }

    public String getCompiler() {
        return this._activeCompiler;
    }

    public ShadowCompilerFactory getCompilerFactoryByName(String string) {
        return (ShadowCompilerFactory)this._store.get(string);
    }

    public void addCompilerFactory(String string, ShadowCompilerFactory shadowCompilerFactory) {
        logger.debug((Object)("FormalismPlugin: adding compiler " + string));
        this._store.addCompilerFactory(string, shadowCompilerFactory);
        this.notifyListeners(string, 0);
        if (this._chosenCompiler.equals(string)) {
            logger.debug((Object)"FormalismPlugin: setting compiler");
            this.setCompiler(this._chosenCompiler);
        }
    }

    public void removeCompilerFactory(String string) {
        if (this._store.containsKey(string)) {
            logger.debug((Object)("FormalismPlugin: removing compiler " + string));
            this._store.remove(string);
            this.notifyListeners(string, 1);
            if (string.equals(this._activeCompiler)) {
                logger.debug((Object)"FormalismPlugin: unsetting compiler");
                this._chosenCompiler = string;
                this.setCompiler(JAVA_COMPILER);
            }
        }
    }

    public void addFormalismChangeListener(FormalismChangeListener formalismChangeListener) {
        this._listeners.add(formalismChangeListener);
    }

    public void removeFormalismChangeListener(FormalismChangeListener formalismChangeListener) {
        this._listeners.remove(formalismChangeListener);
    }

    private void notifyListeners(String string, int n) {
        Iterator<FormalismChangeListener> iterator = this._listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().formalismChanged(string, (Object)this, n);
        }
    }

    public Iterator<String> getKnownFormalisms() {
        return this._store.getKnownFormalisms();
    }

    public static FormalismPlugin getCurrent() {
        for (IPlugin iPlugin : PluginManager.getInstance().getPlugins()) {
            if (!(iPlugin instanceof FormalismPlugin)) continue;
            return (FormalismPlugin)iPlugin;
        }
        return null;
    }

    public class SetFormalismCommand
    implements CLCommand {
        public void execute(String[] stringArray, PrintStream printStream) {
            if (stringArray.length == 0) {
                printStream.println("usage: setFormalism <formalismName>");
                return;
            }
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + " ";
            }
            if (!FormalismPlugin.this._store.containsKey(string = string.trim())) {
                printStream.println("unknown formalism: " + string);
                return;
            }
            FormalismPlugin.this.setCompiler(string);
        }

        public String getDescription() {
            return "sets the named formalism.";
        }
    }

    public class ListFormalismsCommand
    implements CLCommand {
        public void execute(String[] stringArray, PrintStream printStream) {
            printStream.println(CollectionLister.toString(FormalismPlugin.this.getKnownFormalisms()));
        }

        public String getDescription() {
            return "display a list of all available formalisms";
        }
    }
}

