/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.NoArgFunction;
import de.renew.unify.Impossible;
import de.renew.util.ReflectionSerializer;
import de.renew.util.Value;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public class StaticFieldFunction
implements NoArgFunction {
    private transient Field field;

    public StaticFieldFunction(Field field) {
        this.field = field;
    }

    public Object function() throws Impossible {
        try {
            return Value.possiblyWrap((Object)this.field.get(null), (boolean)this.field.getType().isPrimitive());
        }
        catch (Exception exception) {
            if (exception instanceof NullPointerException) {
                throw new Impossible("Static field access impossible: non-static field (" + this.field + ")", (Throwable)exception);
            }
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                throw new Impossible("Static field access resulted in exception (" + this.field + "): " + throwable, throwable);
            }
            throw new Impossible("Exception occured during static field access (" + this.field + "): " + exception, (Throwable)exception);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ReflectionSerializer.writeField((ObjectOutputStream)objectOutputStream, (Field)this.field);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.field = ReflectionSerializer.readField((ObjectInputStream)objectInputStream);
    }

    public String toString() {
        return "StaticFieldFunc(" + this.field + ")";
    }
}

