/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.formalism.function.CastFunction;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.FlexibleArc;
import de.renew.shadow.SyntaxException;
import de.renew.unify.List;
import de.renew.util.Types;
import java.util.Collection;

public class FlexibleInArcFactory
implements ArcFactory {
    public static FlexibleInArcFactory INSTANCE = new FlexibleInArcFactory();

    private FlexibleInArcFactory() {
    }

    @Override
    public void emptyArcCheck() throws SyntaxException {
        throw new SyntaxException("Flexible arcs must be inscribed.");
    }

    @Override
    public boolean allowsTime() {
        return false;
    }

    @Override
    public void compileArc(Place place, Transition transition, boolean bl, Class<?> clazz, TimedExpression timedExpression) throws SyntaxException {
        FlexibleArc flexibleArc;
        TypedExpression typedExpression = timedExpression.getExpression();
        CastFunction castFunction = null;
        CastFunction castFunction2 = null;
        Class<?> clazz2 = typedExpression.getType();
        if (clazz2 != Types.UNTYPED) {
            if (clazz2 == null) {
                throw new SyntaxException("Null not allowed for flexible arcs.");
            }
            if (!(List.class.isAssignableFrom(clazz2) || Collection.class.isAssignableFrom(clazz2) || clazz2.isArray())) {
                throw new SyntaxException("Incorrect type for flexible arc inscription.");
            }
        }
        if (clazz != Types.UNTYPED && clazz2.isArray()) {
            flexibleArc = clazz2.getComponentType();
            if (!Types.allowsLosslessWidening(clazz, flexibleArc) && !Types.allowsLosslessWidening((Class)flexibleArc, clazz)) {
                throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(clazz) + " to " + JavaHelper.makeTypeErrorString(flexibleArc) + " or vice versa.");
            }
            castFunction = new CastFunction(clazz);
            castFunction2 = new CastFunction((Class<?>)flexibleArc);
        }
        flexibleArc = new FlexibleArc(place, transition, -1, typedExpression.getExpression(), castFunction, castFunction2);
        flexibleArc.setTrace(bl);
        transition.add((TransitionInscription)flexibleArc);
    }
}

