/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.importFormats.ImportFormat;
import CH.ifa.draw.util.Iconkit;
import de.renew.navigator.FileTreeCellRenderer;
import de.renew.navigator.FileTreeNode;
import de.renew.navigator.MutableFileTreeNode;
import de.renew.navigator.TreeActionListener;
import de.renew.navigator.TreeKeyListener;
import de.renew.navigator.TreeMouseListener;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class NavigatorGUI
extends JFrame {
    private static Logger logger = Logger.getLogger(NavigatorGUI.class);
    public static final long serialVersionUID = 97936353687387679L;
    public static String filesAtStartup = "";
    public static final String FILES_AT_STARTUP = "de.renew.navigator.filesAtStartup";
    public static String workspaceLocation = "";
    public static final String WORKSPACE_LOCATION = "de.renew.navigator.workspace";
    public static final String IMAGES = "/de/renew/navigator/images/";
    public static final String ICON_ADD = "/de/renew/navigator/images/eclipse-icons/obj16/add_obj.gif";
    public static final String ICON_COLLAPSEALL = "/de/renew/navigator/images/eclipse-icons/elcl16/collapseall.gif";
    public static final String ICON_FILE_AIP = "/de/renew/navigator/images/application-x-renew-interactiondiagram.png";
    public static final String ICON_FILE_DEFAULT = "/de/renew/navigator/images/plain-sheet-48x48.png";
    public static final String ICON_FILE_DRAW = "/de/renew/navigator/images/application-x-renew-drawing.png";
    public static final String ICON_FILE_RNW = "/de/renew/navigator/images/application-x-renew-net.png";
    public static final String ICON_HOME = "/de/renew/navigator/images/eclipse-icons/elcl16/home_nav.gif";
    public static final String ICON_NAVIGATOR = "/de/renew/navigator/images/eclipse-icons/eview16/filenav_nav.gif";
    public static final String ICON_NETPATH = "/de/renew/navigator/images/eclipse-icons/eview16/bkmrk_nav.gif";
    public static final String ICON_REFRESHALL = "/de/renew/navigator/images/eclipse-icons/elcl16/refresh_nav.gif";
    public static final String ICON_REMOVEALL = "/de/renew/navigator/images/eclipse-icons/elcl16/progress_remall.gif";
    public static final String ICON_REMOVEONE = "/de/renew/navigator/images/eclipse-icons/elcl16/progress_rem.gif";
    private IPlugin _simulatorPlugin = null;
    private JPanel _mainPanel = null;
    private JPanel _menuPanel = null;
    private JScrollPane _scrollPane = null;
    private JPanel _treePanel = null;
    private JTree _tree = null;
    private DefaultMutableTreeNode _rootNode = null;
    private DefaultTreeModel _treeModel = null;
    private FileTreeCellRenderer _treeRenderer = null;
    private JPopupMenu _contextMenu = null;
    private TreeMouseListener _treeMouseListener = null;
    private TreeActionListener _treeActionListener = null;
    private TreeKeyListener _treeKeyListener = null;
    private File _previousFile = null;
    private CombinationFileFilter _cff = null;

    public NavigatorGUI() {
        super("(File-)Navigator");
    }

    public void init() {
        Object object;
        this.setPreferredSize(new Dimension(250, 600));
        this.setLocation(0, 150);
        this._simulatorPlugin = (IPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next();
        this._cff = DrawPlugin.getCurrent().getIOHelper().getFileFilter();
        ImportFormat[] importFormatArray = DrawPlugin.getCurrent().getImportHolder().allImportFormats();
        for (ImportFormat importFormat : importFormatArray) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(NavigatorGUI.class.getSimpleName() + ": import format " + importFormat.fileFilter().getDescription()));
            }
            if (!(importFormat.fileFilter() instanceof SimpleFileFilter)) continue;
            this._cff.add((SimpleFileFilter)importFormat.fileFilter());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)(NavigatorGUI.class.getSimpleName() + ": added " + importFormat.fileFilter().getDescription()));
        }
        this._cff.allowDirectory(true);
        this._cff.allowHidden(false);
        if (logger.isDebugEnabled()) {
            object = this._cff.getFileFilters();
            Iterator iterator = ((HashSet)object).iterator();
            while (iterator.hasNext()) {
                SimpleFileFilter simpleFileFilter = (SimpleFileFilter)iterator.next();
                logger.debug((Object)(NavigatorGUI.class.getSimpleName() + ": " + simpleFileFilter.getExtension()));
            }
        }
        Iconkit.instance().registerImage(ICON_ADD);
        Iconkit.instance().registerImage(ICON_COLLAPSEALL);
        Iconkit.instance().registerImage(ICON_FILE_AIP);
        Iconkit.instance().registerImage(ICON_FILE_DEFAULT);
        Iconkit.instance().registerImage(ICON_FILE_DRAW);
        Iconkit.instance().registerImage(ICON_FILE_RNW);
        Iconkit.instance().registerImage(ICON_HOME);
        Iconkit.instance().registerImage(ICON_NAVIGATOR);
        Iconkit.instance().registerImage(ICON_NETPATH);
        Iconkit.instance().registerImage(ICON_REFRESHALL);
        Iconkit.instance().registerImage(ICON_REMOVEALL);
        Iconkit.instance().registerImage(ICON_REMOVEONE);
        this.setIconImage(Iconkit.instance().getImage(ICON_NAVIGATOR));
        this._treeMouseListener = new TreeMouseListener(this);
        this._treeActionListener = new TreeActionListener(this);
        this._treeKeyListener = new TreeKeyListener(this);
        this._mainPanel = new JPanel();
        this._mainPanel.setLayout(new BoxLayout(this._mainPanel, 3));
        this.add(this._mainPanel);
        this._menuPanel = new JPanel();
        this._menuPanel.setLayout(new BoxLayout(this._menuPanel, 2));
        this._menuPanel.add(Box.createHorizontalGlue());
        this._mainPanel.add(this._menuPanel);
        object = null;
        Dimension dimension = new Dimension(33, 20);
        object = new JButton(new ImageIcon(Iconkit.instance().getImage(ICON_HOME)));
        ((JComponent)object).setToolTipText("Open Home paths of Navigator properties");
        ((AbstractButton)object).setActionCommand("Open Home");
        ((AbstractButton)object).addActionListener(this._treeActionListener);
        ((JComponent)object).setMinimumSize(dimension);
        ((JComponent)object).setPreferredSize(dimension);
        this._menuPanel.add((Component)object);
        object = new JButton(new ImageIcon(Iconkit.instance().getImage(ICON_NETPATH)));
        ((JComponent)object).setToolTipText("Open NetPaths of simulator properties");
        ((AbstractButton)object).setActionCommand("Open NetPaths");
        ((AbstractButton)object).addActionListener(this._treeActionListener);
        ((JComponent)object).setMinimumSize(dimension);
        ((JComponent)object).setPreferredSize(dimension);
        this._menuPanel.add((Component)object);
        object = new JButton(new ImageIcon(Iconkit.instance().getImage(ICON_ADD)));
        ((JComponent)object).setToolTipText("Add Files (Ctrl+Shift+O)");
        ((AbstractButton)object).setActionCommand("Add Files");
        ((AbstractButton)object).addActionListener(this._treeActionListener);
        ((JComponent)object).setMinimumSize(dimension);
        ((JComponent)object).setPreferredSize(dimension);
        this._menuPanel.add((Component)object);
        object = new JButton(new ImageIcon(Iconkit.instance().getImage(ICON_COLLAPSEALL)));
        ((JComponent)object).setToolTipText("Collapse All (Ctrl+Shift+C)");
        ((AbstractButton)object).setActionCommand("Collapse All");
        ((AbstractButton)object).addActionListener(this._treeActionListener);
        ((JComponent)object).setMinimumSize(dimension);
        ((JComponent)object).setPreferredSize(dimension);
        this._menuPanel.add((Component)object);
        object = new JButton(new ImageIcon(Iconkit.instance().getImage(ICON_REFRESHALL)));
        ((JComponent)object).setToolTipText("Refresh All (Ctrl+R)");
        ((AbstractButton)object).setActionCommand("Refresh All");
        ((AbstractButton)object).addActionListener(this._treeActionListener);
        ((JComponent)object).setMinimumSize(dimension);
        ((JComponent)object).setPreferredSize(dimension);
        this._menuPanel.add((Component)object);
        object = new JButton(new ImageIcon(Iconkit.instance().getImage(ICON_REMOVEONE)));
        ((JComponent)object).setToolTipText("Remove Node");
        ((AbstractButton)object).setActionCommand("Remove TreeNode");
        ((AbstractButton)object).addActionListener(this._treeActionListener);
        ((JComponent)object).setMinimumSize(dimension);
        ((JComponent)object).setPreferredSize(dimension);
        this._menuPanel.add((Component)object);
        object = new JButton(new ImageIcon(Iconkit.instance().getImage(ICON_REMOVEALL)));
        ((JComponent)object).setToolTipText("Remove All (Ctrl+Shift+Delete)");
        ((AbstractButton)object).setActionCommand("Remove All");
        ((AbstractButton)object).addActionListener(this._treeActionListener);
        ((JComponent)object).setMinimumSize(dimension);
        ((JComponent)object).setPreferredSize(dimension);
        this._menuPanel.add((Component)object);
        this._rootNode = new DefaultMutableTreeNode("rootNode");
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree = new JTree(this._treeModel){
            private static final long serialVersionUID = 3105716467712346866L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (mouseEvent == null) {
                    return null;
                }
                TreePath treePath = NavigatorGUI.this._tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    return NavigatorGUI.this.getTreeNodePath(treePath);
                }
                return null;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.setRootVisible(false);
        this._tree.setFocusable(true);
        this._tree.getSelectionModel().setSelectionMode(4);
        this._tree.addMouseListener(this._treeMouseListener);
        this._tree.addKeyListener(this._treeKeyListener);
        this._tree.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        this._treeRenderer = new FileTreeCellRenderer();
        this._treeRenderer.setDefaultIcon(new ImageIcon(Iconkit.instance().getImage(ICON_FILE_DEFAULT).getScaledInstance(18, -1, 4)));
        this._treeRenderer.addIcon(".aip", new ImageIcon(Iconkit.instance().getImage(ICON_FILE_AIP).getScaledInstance(18, -1, 4)));
        this._treeRenderer.addIcon(".draw", new ImageIcon(Iconkit.instance().getImage(ICON_FILE_DRAW).getScaledInstance(18, -1, 4)));
        this._treeRenderer.addIcon(".rnw", new ImageIcon(Iconkit.instance().getImage(ICON_FILE_RNW).getScaledInstance(18, -1, 4)));
        this._treeRenderer.addIcon(".arm", new ImageIcon(Iconkit.instance().getImage(ICON_FILE_RNW).getScaledInstance(18, -1, 4)));
        this._treeRenderer.addIcon(".mad", new ImageIcon(Iconkit.instance().getImage(ICON_FILE_RNW).getScaledInstance(18, -1, 4)));
        this._treeRenderer.addIcon(".net", new ImageIcon(Iconkit.instance().getImage(ICON_FILE_RNW).getScaledInstance(18, -1, 4)));
        this._tree.setCellRenderer(this._treeRenderer);
        this._treePanel = new JPanel(new BorderLayout());
        this._treePanel.setAlignmentX(0.0f);
        this._treePanel.setBackground(Color.WHITE);
        this._treePanel.add((Component)this._tree, "Before");
        this._scrollPane = new JScrollPane(this._treePanel);
        this._scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this._scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this._mainPanel.add(this._scrollPane);
    }

    private String getTreeNodePath(TreePath treePath) {
        try {
            MutableFileTreeNode mutableFileTreeNode = (MutableFileTreeNode)treePath.getLastPathComponent();
            return mutableFileTreeNode.getFile().getPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean addFilesFromProperties() {
        IPlugin iPlugin = PluginManager.getInstance().getPluginByName("Navigator");
        try {
            filesAtStartup = iPlugin.getProperties().getProperty(FILES_AT_STARTUP);
            workspaceLocation = iPlugin.getProperties().getProperty(WORKSPACE_LOCATION);
            if (!workspaceLocation.endsWith("/")) {
                workspaceLocation = workspaceLocation + "/";
            }
            String[] stringArray = filesAtStartup.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                File file;
                String string = stringArray[i];
                if (!string.startsWith("/")) {
                    string = workspaceLocation + string;
                }
                if ((file = new File(string)).exists()) {
                    this.addFile(file, (FileFilter)this._cff);
                }
                this.collapseAll();
            }
            return stringArray.length > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addFiles() {
        File[] fileArray;
        JFileChooser jFileChooser = new JFileChooser(DrawPlugin.getCurrent().getIOHelper().getCurrentDirectory(this._previousFile != null ? this._previousFile : null));
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter((javax.swing.filechooser.FileFilter)this._cff);
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (fileArray = jFileChooser.getSelectedFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.addFile(fileArray[i], (FileFilter)this._cff);
            }
            File file = fileArray[0].getParentFile();
            if (file != null && file.isDirectory()) {
                DrawPlugin.getCurrent().getIOHelper().setLastPath(file);
            }
            this._previousFile = fileArray[0];
        }
    }

    public boolean addFile(String string) {
        File file = new File(string);
        return this.addFile(file, (FileFilter)this._cff);
    }

    public boolean addFile(File file, FileFilter fileFilter) {
        if (file.exists()) {
            MutableFileTreeNode mutableFileTreeNode;
            Enumeration<TreeNode> enumeration = this._rootNode.children();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                mutableFileTreeNode = (MutableFileTreeNode)enumeration.nextElement();
                if (!mutableFileTreeNode.getFile().getPath().equals(file.getPath())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                mutableFileTreeNode = new MutableFileTreeNode(file, fileFilter);
                this._treeModel.insertNodeInto(mutableFileTreeNode, this._rootNode, this._rootNode.getChildCount());
                TreePath treePath = new TreePath(mutableFileTreeNode.getPath());
                this._tree.expandPath(treePath);
                this._tree.scrollPathToVisible(treePath);
                this._scrollPane.validate();
                this._mainPanel.validate();
                this._mainPanel.repaint();
                return true;
            }
        }
        return false;
    }

    public void remove(MutableTreeNode mutableTreeNode) {
        this._treeModel.removeNodeFromParent(mutableTreeNode);
    }

    public void remove() {
        TreePath treePath = this._tree.getSelectionPath();
        if (treePath != null && treePath.getLastPathComponent() != null) {
            try {
                this._treeModel.removeNodeFromParent((MutableTreeNode)treePath.getLastPathComponent());
            }
            catch (Exception exception) {
                System.out.println("Remove failed " + exception.getMessage());
            }
        }
    }

    public void open(int n, int n2) {
        FileTreeNode fileTreeNode;
        File file;
        Object object;
        TreePath treePath = this._tree.getPathForLocation(n, n2);
        if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof FileTreeNode && !(file = (fileTreeNode = (FileTreeNode)object).getFile()).isDirectory()) {
            DrawPlugin.getCurrent().getIOHelper().loadAndOpenDrawing(file);
        }
    }

    public void openSelected() {
        TreePath[] treePathArray = this._tree.getSelectionPaths();
        for (int i = 0; i < this._tree.getSelectionCount(); ++i) {
            FileTreeNode fileTreeNode;
            File file;
            Object object = treePathArray[i].getLastPathComponent();
            if (object == null || !(object instanceof FileTreeNode) || (file = (fileTreeNode = (FileTreeNode)object).getFile()).isDirectory()) continue;
            DrawPlugin.getCurrent().getIOHelper().loadAndOpenDrawing(file);
        }
    }

    public void closeSelected() {
        TreePath[] treePathArray = this._tree.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            MutableTreeNode mutableTreeNode;
            Object object = treePathArray[i].getLastPathComponent();
            if (object == null || !(object instanceof MutableTreeNode) || (mutableTreeNode = (MutableTreeNode)object).getParent() != this._rootNode) continue;
            this._treeModel.removeNodeFromParent(mutableTreeNode);
        }
    }

    public void showContextMenu(int n, int n2) {
        MutableTreeNode mutableTreeNode;
        Object object;
        TreePath treePath = this._tree.getPathForLocation(n, n2);
        if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof MutableTreeNode && (mutableTreeNode = (MutableTreeNode)object).getParent() == this._rootNode) {
            this._contextMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Remove Tree");
            this._treeActionListener.setTreeNode(mutableTreeNode);
            jMenuItem.addActionListener(this._treeActionListener);
            this._contextMenu.add(jMenuItem);
            this._contextMenu.show(this._tree, n, n2);
        }
    }

    public void closeAll() {
        this._rootNode.removeAllChildren();
        this._treeModel.nodeStructureChanged(this._rootNode);
    }

    public void collapseAll() {
        this._tree.collapsePath(new TreePath(this._rootNode));
        this._treeModel.nodeStructureChanged(this._rootNode);
    }

    public void refreshAll() {
        for (int i = this._tree.getRowCount() - 1; i >= 0; --i) {
            TreePath treePath = this._tree.getPathForRow(i);
            Object object = treePath.getLastPathComponent();
            if (object == null || !(object instanceof MutableFileTreeNode)) continue;
            MutableFileTreeNode mutableFileTreeNode = (MutableFileTreeNode)object;
            this.refresh(mutableFileTreeNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean refresh(MutableFileTreeNode mutableFileTreeNode) {
        if (!mutableFileTreeNode.exists()) {
            this._treeModel.removeNodeFromParent(mutableFileTreeNode);
            return true;
        }
        if (!mutableFileTreeNode.getAllowsChildren()) return false;
        if (this._tree.isExpanded(new TreePath(mutableFileTreeNode.getPath()))) {
            if (mutableFileTreeNode.getChildCount() == 0) {
                if (!mutableFileTreeNode.reloadChildren()) return false;
                this._treeModel.nodeStructureChanged(mutableFileTreeNode);
                return true;
            }
            File[] fileArray = mutableFileTreeNode.getChildFiles();
            mutableFileTreeNode.ensureCapacity(fileArray.length);
            TreeNode treeNode = null;
            int n = 0;
            boolean bl = false;
            while (n < mutableFileTreeNode.getChildCount()) {
                treeNode = mutableFileTreeNode.getChildAt(n);
                if (treeNode instanceof MutableFileTreeNode && !((MutableFileTreeNode)treeNode).getFile().exists()) {
                    this._treeModel.removeNodeFromParent((MutableFileTreeNode)treeNode);
                    bl = true;
                    continue;
                }
                ++n;
            }
            for (n = 0; n < fileArray.length; ++n) {
                boolean bl2 = false;
                int n2 = -1;
                for (int i = 0; i < mutableFileTreeNode.getChildCount(); ++i) {
                    treeNode = mutableFileTreeNode.getChildAt(i);
                    if (!(treeNode instanceof MutableFileTreeNode)) continue;
                    int n3 = fileArray[n].compareTo(((MutableFileTreeNode)treeNode).getFile());
                    if (n3 == 0) {
                        bl2 = true;
                        break;
                    }
                    if (n3 >= 0 || n2 != -1) continue;
                    n2 = i;
                }
                if (bl2) continue;
                if (n2 < 0) {
                    n2 = mutableFileTreeNode.getChildCount();
                }
                MutableFileTreeNode mutableFileTreeNode2 = new MutableFileTreeNode(mutableFileTreeNode, fileArray[n], (FileFilter)this._cff);
                this._treeModel.insertNodeInto(mutableFileTreeNode2, mutableFileTreeNode, n2);
                bl = true;
            }
            return bl;
        }
        if (!mutableFileTreeNode.invalidateChildren()) return false;
        this._treeModel.nodeStructureChanged(mutableFileTreeNode);
        return true;
    }

    public void openHome() {
        this.closeAll();
        if (!this.addFilesFromProperties()) {
            this.addFile(new File(System.getProperty("user.dir")), (FileFilter)this._cff);
        }
    }

    public void openNetPaths() {
        this.closeAll();
        DefaultShadowNetLoader.PathEntry[] pathEntryArray = DefaultShadowNetLoader.canonizePaths((String[])StringUtil.splitPaths((String)this._simulatorPlugin.getProperties().getProperty("de.renew.netPath")));
        for (int i = 0; i < pathEntryArray.length; ++i) {
            if (pathEntryArray[i].isClasspathRelative) continue;
            this.addFile(pathEntryArray[i].path);
        }
    }
}

