/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.Palette;
import de.renew.gui.GuiPlugin;
import de.renew.netcomponents.ComponentsPluginExtender;
import de.renew.netcomponents.ComponentsToolPlugin;
import de.renew.netcomponents.InsertionTool;
import de.renew.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ComponentsTool
implements StatusDisplayer {
    public static Logger logger = Logger.getLogger(ComponentsTool.class);
    protected static String TOOLDIRPROPERTY = "user.toolsdir";
    private Palette palette;
    private String label;
    private boolean toolsDirCheck = false;
    private boolean toolsDirIsSet = false;

    public ComponentsTool() {
        String string = System.getProperty(TOOLDIRPROPERTY);
        logger.debug((Object)string);
        if (string == null || !new File(string).exists()) {
            URL uRL = ComponentsToolPlugin.getLocation();
            String string2 = new File(uRL.getFile()).getAbsolutePath();
            if (new File(string2 = string2.substring(0, string2.lastIndexOf(File.separator)) + File.separator + "tools").exists()) {
                string = string2;
                this.toolsDirIsSet = true;
                String string3 = "The " + TOOLDIRPROPERTY + " property is not set or not valid. Trying plugin location...";
                GuiPlugin.getCurrent().showStatus(string3);
                logger.debug((Object)string3);
            } else {
                this.toolsDirIsSet = false;
                string = "";
                logger.info((Object)("Netcomponents: The " + TOOLDIRPROPERTY + " is not set! \n" + "Override by setting the " + TOOLDIRPROPERTY + " property."));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("netcomponents: using default tooldir '" + string + "'." + "Override by setting the " + TOOLDIRPROPERTY + " property."));
                }
            }
        } else {
            this.toolsDirIsSet = true;
        }
        this.setLabel("default " + string);
        this.createTools(string, "Components", null);
    }

    public ComponentsTool(String string, String string2, ComponentsPluginExtender componentsPluginExtender) {
        this.toolsDirIsSet = true;
        this.setLabel(string);
        this.createTools(string, string2, componentsPluginExtender);
    }

    void createTools(String string, String string2, ComponentsPluginExtender componentsPluginExtender) {
        String[] stringArray;
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin == null) {
            logger.error((Object)"ComponentsPlugin: no GuiPlugin available!");
            return;
        }
        JFrame jFrame = guiPlugin.getGuiFrame();
        if (jFrame == null) {
            logger.error((Object)"NetComponents: could not create Tools: no GUI available.");
        }
        this.palette = new Palette(jFrame, string2);
        File file = new File(string);
        File file2 = new File(string + File.separator + "images");
        Vector<Object> vector = new Vector<Object>();
        try {
            stringArray = new BufferedReader(new FileReader(string + File.separator + ".sequence"));
            while (stringArray.ready()) {
                vector.add(stringArray.readLine());
            }
            stringArray.close();
        }
        catch (Exception exception) {
            logger.error((Object)("The File" + string + File.separator + ".sequence" + " could not be found " + exception));
        }
        if (file.isDirectory()) {
            if (file2.isDirectory()) {
                Object object;
                Object object22;
                stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    object22 = StringUtil.getFilename((String)stringArray[i]);
                    object = StringUtil.getExtension((String)stringArray[i]);
                    if (!new File(string + File.separator + stringArray[i]).isFile() || !"rnw".equals(object) || vector.contains(object22)) continue;
                    vector.add(object22);
                }
                if (new File(string + File.separator + "images" + File.separator + "generic.gif").exists()) {
                    for (Object object22 : vector) {
                        object = this.createToolButton((String)object22, string, guiPlugin);
                        if (object != null) {
                            this.palette.add((ToolButton)object);
                        }
                        this.toolsDirCheck = true;
                    }
                    if (componentsPluginExtender != null && (object22 = componentsPluginExtender.getAdditionalButtons()) != null) {
                        object = ((Vector)object22).iterator();
                        while (object.hasNext()) {
                            ToolButton toolButton = (ToolButton)object.next();
                            this.palette.add(toolButton);
                        }
                    }
                    if (this.toolsDirIsValid()) {
                        guiPlugin.getPaletteHolder().addPalette(this.palette);
                    }
                } else {
                    logger.error((Object)("The directory " + string + File.separator + "images seems to exist"));
                    logger.error((Object)"but it does not contain the files generic.gif");
                    logger.error((Object)"So I think that the toolsdir variable is not set to a proper toolsdir directory");
                    logger.error((Object)"or the selected directory does not match the requirements.");
                    logger.error((Object)"A proper toolsdir directory contains the images directory  ");
                    logger.error((Object)"which contains at least the file generic.gif as fallback and a .sequence file.");
                    logger.error((Object)"");
                }
            } else {
                logger.error((Object)("The directory " + string + File.separator + "images does not exist!"));
            }
        } else {
            logger.error((Object)("The directory " + string + " does not exist!"));
        }
    }

    private ToolButton createToolButton(String string, String string2, GuiPlugin guiPlugin) {
        Drawing drawing;
        String string3 = string + ".rnw";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(ComponentsTool.class.getName() + ": dirName: " + string2));
            logger.debug((Object)(ComponentsTool.class.getName() + ": fildeName: " + string3));
        }
        if ((drawing = DrawingFileHelper.loadDrawing((File)new File(string2, string3), (StatusDisplayer)this)) == null) {
            return null;
        }
        Tool tool = this.createInsertionTool(guiPlugin, drawing);
        String string4 = "";
        String string5 = string2 + File.separator + "images" + File.separator;
        File file = new File(string5 + string + ".gif");
        File file2 = new File(string5 + string + ".gif");
        if (file.exists() && file2.exists()) {
            string4 = string;
        } else {
            string4 = "generic";
            logger.warn((Object)("File does not exist: " + file.getAbsolutePath() + " trying to load generic.gif instead."));
        }
        ToolButton toolButton = guiPlugin.getPaletteHolder().createToolButton(string5 + string4, "NC " + string, tool);
        return toolButton;
    }

    private Tool createInsertionTool(GuiPlugin guiPlugin, Drawing drawing) {
        DrawingEditor drawingEditor = guiPlugin.getDrawingEditor();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ComponentsTool: " + drawing));
        }
        FigureEnumeration figureEnumeration = drawing.figures();
        Vector<Figure> vector = new Vector<Figure>();
        while (figureEnumeration.hasMoreElements()) {
            vector.addElement((Figure)figureEnumeration.nextElement());
        }
        InsertionTool insertionTool = new InsertionTool(drawingEditor, vector);
        return insertionTool;
    }

    public void remove() {
        GuiPlugin guiPlugin = GuiPlugin.getCurrent();
        if (guiPlugin != null) {
            guiPlugin.getPaletteHolder().removePalette(this.palette);
        }
    }

    private void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean toolsDirIsSet() {
        return this.toolsDirIsSet;
    }

    public boolean toolsDirIsValid() {
        return this.toolsDirCheck;
    }

    public void showStatus(String string) {
        logger.warn((Object)(ComponentsTool.class.getSimpleName() + ": A file could not be loaded."));
        logger.warn((Object)(ComponentsTool.class.getSimpleName() + ": Turn on debug to display more information."));
        logger.warn((Object)(ComponentsTool.class.getSimpleName() + ": To do so add line log4j.logger.de.renew.netcomponents.ComponentsTool=DEBUG"));
        logger.warn((Object)(ComponentsTool.class.getSimpleName() + ": to your log4j configuration in e.g. ~/.log4j.properties."));
        logger.debug((Object)string);
    }
}

