/*
 * Decompiled with CFR 0.152.
 */
package de.renew.netcomponents;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.GroupHandle;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class NetComponentFigure
extends AttributeFigure
implements FigureChangeListener {
    Vector<Figure> attached = new Vector();

    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.draw(float_);
    }

    public void drawBackground(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.fill(float_);
    }

    public Collection<Figure> group(Collection<Figure> collection) {
        for (Figure figure : collection) {
            if (figure instanceof ChildFigure && ((ChildFigure)figure).parent() != null || this.attached.contains(figure)) continue;
            this.attached.add(figure);
            figure.addFigureChangeListener((FigureChangeListener)this);
        }
        return collection;
    }

    protected void basicMoveBy(int n, int n2) {
        Vector vector = this.getView().selection();
        for (AttributeFigure attributeFigure : this.attached) {
            if (vector.contains(attributeFigure)) continue;
            attributeFigure.moveBy(n, n2);
        }
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public Rectangle displayBox() {
        Enumeration<Figure> enumeration = this.attached.elements();
        Rectangle rectangle = new Rectangle();
        if (enumeration.hasMoreElements()) {
            rectangle = enumeration.nextElement().displayBox();
        }
        while (enumeration.hasMoreElements()) {
            rectangle.add(enumeration.nextElement().displayBox());
        }
        if (rectangle == null) {
            return new Rectangle(0, 0);
        }
        return rectangle;
    }

    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement((Handle)new GroupHandle((Figure)this, RelativeLocator.northWest()));
        vector.addElement((Handle)new GroupHandle((Figure)this, RelativeLocator.northEast()));
        vector.addElement((Handle)new GroupHandle((Figure)this, RelativeLocator.southWest()));
        vector.addElement((Handle)new GroupHandle((Figure)this, RelativeLocator.southEast()));
        return vector;
    }

    public void moveBy(int n, int n2) {
        DrawingView drawingView = this.getView();
        if (drawingView == null) {
            return;
        }
        Vector vector = drawingView.selection();
        for (Figure figure : this.attached) {
            if (vector.contains(figure)) continue;
            figure.moveBy(n, n2);
        }
        this.changed();
    }

    public boolean isSelectable() {
        return true;
    }

    private DrawingView getView() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        if (drawApplication == null) {
            return null;
        }
        return drawApplication.getView(drawApplication.drawing());
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.attached.size());
        for (Figure figure : this.attached) {
            storableOutput.writeStorable((Storable)figure);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        if (storableInput.getVersion() > 9) {
            super.read(storableInput);
        }
        this.attached = new Vector();
        int n = storableInput.readInt();
        if (n != 0) {
            for (int i = 1; i <= n; ++i) {
                Figure figure = (Figure)storableInput.readStorable();
                this.attached.add(figure);
                figure.addFigureChangeListener((FigureChangeListener)this);
            }
        }
        Enumeration enumeration = this.getAttributeKeys();
        boolean bl = false;
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("FillColor")) {
                bl = true;
            }
            if (!string.equals("FrameColor")) continue;
            bl2 = true;
        }
        if (!bl) {
            this.setFillColor(ColorMap.NONE);
        }
        if (!bl2) {
            this.setFrameColor(ColorMap.NONE);
            this.setAttribute("LineStyle", "1 2");
        }
    }

    public Vector<Figure> getAttached() {
        return this.attached;
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            return super.inspect(drawingView, bl);
        }
        drawingView.clearSelection();
        drawingView.addToSelectionAll(this.attached);
        return true;
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.invalidate();
        this.changed();
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        Figure figure = figureChangeEvent.getFigure();
        this.attached.remove(figure);
        if (this.attached.isEmpty() && this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent((Figure)this));
        }
        this.invalidate();
        this.changed();
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    public void figureHandlesChanged(FigureChangeEvent figureChangeEvent) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        Enumeration<Figure> enumeration = this.attached.elements();
        while (enumeration.hasMoreElements()) {
            FigureEnumeration figureEnumeration = DrawPlugin.getGui().drawing().figures();
            Figure figure = enumeration.nextElement();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure2 = (Figure)figureEnumeration.nextElement();
                if (!figure2.equals(figure)) continue;
                figure.addToContainer((FigureChangeListener)this);
            }
        }
    }

    public FigureEnumeration getFiguresWithDependencies() {
        return new MergedFigureEnumerator(super.getFiguresWithDependencies(), this.getAttachedFigures());
    }

    private FigureEnumeration getAttachedFigures() {
        return new FigureEnumerator(this.attached);
    }

    public void updateListeners() {
        FigureEnumeration figureEnumeration = this.getFiguresWithDependencies();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.addToContainer((FigureChangeListener)this);
        }
    }
}

