/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.gui.ConfigureEngineController;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.logging.AppenderFactory;
import de.renew.gui.logging.ConfigureLoggingTab;
import de.renew.gui.logging.GenericAppenderEditor;
import de.renew.gui.logging.NewLoggerDialog;
import de.renew.gui.logging.TreeNodeAppenderWrapper;
import de.renew.gui.logging.TreeNodeLoggerWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;

public class ConfigureLoggingController
implements ConfigureSimulationTabController,
TreeSelectionListener {
    public static Logger logger = Logger.getLogger(ConfigureEngineController.class);
    private ConfigureLoggingTab tab = new ConfigureLoggingTab(this);

    public ConfigureLoggingController() {
        this.tab.setRootNode(this.createLoggerTreeNodes());
    }

    public Component getTab() {
        return this.tab;
    }

    private MutableTreeNode createLoggerTreeNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("defined loggers");
        Enumeration enumeration = LogManager.getCurrentLoggers();
        while (enumeration.hasMoreElements()) {
            Logger logger = (Logger)enumeration.nextElement();
            if (!logger.getName().startsWith("simulation")) continue;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new TreeNodeLoggerWrapper(logger));
            boolean bl = false;
            Enumeration enumeration2 = logger.getAllAppenders();
            while (enumeration2.hasMoreElements()) {
                bl = true;
                Appender appender = (Appender)enumeration2.nextElement();
                if (appender instanceof NullAppender) continue;
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new TreeNodeAppenderWrapper(logger, appender));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            if (!bl) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        return defaultMutableTreeNode;
    }

    public void commitTab(Properties properties) {
    }

    public void updateTab(Properties properties) {
        this.tab.setRootNode(this.createLoggerTreeNodes());
    }

    protected ActionListener createAddLoggerAction() {
        return new AddLoggerAction();
    }

    protected ActionListener createRemoveLoggerAction(String string) {
        return new RemoveLoggerAction(string);
    }

    protected ActionListener createAddAppenderAction(String string, String string2) {
        return new AddAppenderAction(string, string2);
    }

    protected ActionListener createRemoveAppenderAction(String string, Appender appender) {
        return new RemoveAppenderAction(string, appender);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = ((DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent()).getUserObject();
        if (object instanceof TreeNodeAppenderWrapper) {
            Appender appender = ((TreeNodeAppenderWrapper)object).getAppender();
            this.tab.setRightSide(new JScrollPane(new GenericAppenderEditor(appender)));
        }
    }

    private class RemoveAppenderAction
    implements ActionListener {
        private String loggerName;
        private Appender appender;

        public RemoveAppenderAction(String string, Appender appender) {
            this.loggerName = string;
            this.appender = appender;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Logger.getLogger((String)this.loggerName).removeAppender(this.appender);
            ConfigureLoggingController.this.updateTab(null);
        }
    }

    private class AddAppenderAction
    implements ActionListener {
        private String loggerName;
        private String appenderTypeName;

        public AddAppenderAction(String string, String string2) {
            this.loggerName = string;
            this.appenderTypeName = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Appender appender = AppenderFactory.getInstance().createNewAppender(this.appenderTypeName);
                Logger.getLogger((String)this.loggerName).addAppender(appender);
                ConfigureLoggingController.this.updateTab(null);
            }
            catch (Exception exception) {
                logger.error((Object)("Can't create new appender instance of appender type " + this.appenderTypeName));
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private class RemoveLoggerAction
    implements ActionListener {
        private String loggerName;

        public RemoveLoggerAction(String string) {
            this.loggerName = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Logger logger = Logger.getLogger((String)this.loggerName);
            logger.removeAllAppenders();
            ConfigureLoggingController.this.updateTab(null);
        }
    }

    private class AddLoggerAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            Logger logger = null;
            NewLoggerDialog newLoggerDialog = new NewLoggerDialog(this.getParentDialog());
            newLoggerDialog.setVisible(true);
            if (newLoggerDialog.isCommitted()) {
                while (!bl) {
                    String string = "simulation." + newLoggerDialog.getLogger();
                    logger = Logger.getLogger((String)string);
                    Enumeration enumeration = logger.getAllAppenders();
                    if (enumeration.hasMoreElements()) continue;
                    bl = true;
                }
            }
            if (logger != null) {
                logger.addAppender((Appender)new NullAppender());
            }
            ConfigureLoggingController.this.updateTab(null);
        }

        private Dialog getParentDialog() {
            Container container = ConfigureLoggingController.this.tab;
            while (!(container instanceof Dialog)) {
                container = container.getParent();
            }
            return (Dialog)container;
        }
    }
}

