/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import de.renew.application.SimulatorPlugin;
import de.renew.engine.events.NetEvent;
import de.renew.engine.events.PlaceEvent;
import de.renew.engine.events.SimulationEvent;
import de.renew.engine.events.TransitionEvent;
import de.renew.gui.CPNApplication;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceFigure;
import de.renew.gui.logging.ErrorLevelTableRenderer;
import de.renew.gui.logging.MainRepositoryManager;
import de.renew.gui.logging.RepositoryChangeListener;
import de.renew.gui.logging.StepTableModel;
import de.renew.gui.logging.StepTrace;
import de.renew.gui.logging.StepTraceChangeListener;
import de.renew.gui.logging.StepTraceRemoveRequest;
import de.renew.gui.logging.StepTraceRepository;
import de.renew.gui.logging.TableModel;
import de.renew.net.NetElementID;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.TransitionInstanceAccessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class LoggerTableModel
extends TableModel
implements RepositoryChangeListener {
    private static final Logger logger = Logger.getLogger(LoggerTableModel.class);
    private boolean permanentUpdate = true;
    private Set<StepTraceChangeListener> listeners = new HashSet<StepTraceChangeListener>();
    private StepTraceRepository repository;
    private List<StepTrace> traces = new ArrayList<StepTrace>();

    public LoggerTableModel(String string) {
        super(true);
        this.repository = MainRepositoryManager.getInstance().getCurrentRepository(string);
        if (this.repository != null) {
            this.repository.addRepositoryChangeListener(this);
            StepTrace[] stepTraceArray = this.repository.getAllStepTraces();
            for (int i = 0; i < stepTraceArray.length; ++i) {
                this.addStepTrace(stepTraceArray[i]);
            }
        }
    }

    public void setPermanentUpdate(boolean bl) {
        this.permanentUpdate = bl;
    }

    private void addStepTrace(StepTrace stepTrace) {
        if (stepTrace.getStepIdentifier().getComponents().length > 0) {
            JPanel jPanel = new JPanel(new GridLayout(1, 1));
            StepTableModel stepTableModel = new StepTableModel(stepTrace);
            JTable jTable = new JTable(stepTableModel);
            ErrorLevelTableRenderer errorLevelTableRenderer = new ErrorLevelTableRenderer();
            jTable.setDefaultRenderer(Object.class, errorLevelTableRenderer);
            stepTableModel.addTableModelListener(new TableModelListenerImpl(stepTrace));
            jTable.addMouseListener(new PopupMenuMouseListener());
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), stepTrace.toString()));
            jPanel.add(jTable);
            this.addRow(new Object[]{jPanel});
            this.traces.add(stepTrace);
            this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        }
    }

    private void removeStepTrace(StepTrace stepTrace) {
        int n;
        if (stepTrace.getStepIdentifier().getComponents().length > 0 && (n = this.traces.indexOf(stepTrace)) != -1) {
            this.removeRow(n);
            this.traces.remove(n);
            if (this.permanentUpdate) {
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        if (this.permanentUpdate) {
            this.fireStepTraceChanged(stepTrace);
        }
    }

    @Override
    public void stepTraceAdded(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        if (this.permanentUpdate) {
            this.addStepTrace(stepTrace);
            this.fireStepTraceAdded(stepTraceRepository, stepTrace);
        }
    }

    @Override
    public void stepTraceRemoved(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        if (this.permanentUpdate) {
            this.removeStepTrace(stepTrace);
            this.fireStepTraceRemoved(stepTraceRepository, stepTrace);
        }
    }

    @Override
    public void stepTraceRemoveRequest(StepTraceRemoveRequest stepTraceRemoveRequest) {
    }

    public int getIndexOf(StepTrace stepTrace) {
        return this.traces.indexOf(stepTrace);
    }

    public void addRepositoryChangeListener(StepTraceChangeListener stepTraceChangeListener) {
        this.listeners.add(stepTraceChangeListener);
    }

    public void fireStepTraceChanged(StepTrace stepTrace) {
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length; ++i) {
            repositoryChangeListenerArray[i].stepTraceChanged(stepTrace);
        }
    }

    public void fireStepTraceAdded(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length; ++i) {
            repositoryChangeListenerArray[i].stepTraceAdded(stepTraceRepository, stepTrace);
        }
    }

    public void fireStepTraceRemoved(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length; ++i) {
            repositoryChangeListenerArray[i].stepTraceRemoved(stepTraceRepository, stepTrace);
        }
    }

    public void fireStepTraceRemoveRequest(StepTraceRemoveRequest stepTraceRemoveRequest) {
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length; ++i) {
            repositoryChangeListenerArray[i].stepTraceRemoveRequest(stepTraceRemoveRequest);
        }
    }

    private class TableModelListenerImpl
    implements TableModelListener {
        private StepTrace stepTrace;

        public TableModelListenerImpl(StepTrace stepTrace) {
            this.stepTrace = stepTrace;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == 0) {
                LoggerTableModel.this.fireTableCellUpdated(LoggerTableModel.this.getIndexOf(this.stepTrace), 0);
            }
        }
    }

    private class PopupMenuMouseListener
    extends MouseAdapter {
        private PopupMenuMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof JTable && mouseEvent.isPopupTrigger()) {
                this.openPopup((JTable)component, mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof JTable && mouseEvent.isPopupTrigger()) {
                this.openPopup((JTable)component, mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Component component;
            if (mouseEvent.getClickCount() == 2 && (component = mouseEvent.getComponent()) instanceof JTable) {
                this.openDetailView((JTable)component, mouseEvent);
            }
        }

        private void openPopup(JTable jTable, MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = jTable.rowAtPoint(point);
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            listSelectionModel.setSelectionInterval(n, n);
            StepTableModel stepTableModel = (StepTableModel)jTable.getModel();
            SimulationEvent simulationEvent = (SimulationEvent)stepTableModel.getValueAt(n, 0);
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (SimulatorPlugin.getCurrent().isSimulationActive()) {
                RemotePlugin remotePlugin = RemotePlugin.getInstance();
                JMenuItem jMenuItem = new JMenuItem("show net pattern");
                if (!(simulationEvent instanceof NetEvent)) {
                    jMenuItem.setEnabled(false);
                } else {
                    jMenuItem.addActionListener(new OpenNetPatternAction(remotePlugin.wrapInstance(((NetEvent)simulationEvent).getNetInstance())));
                }
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem("show net instance");
                if (!(simulationEvent instanceof NetEvent)) {
                    jMenuItem2.setEnabled(false);
                } else {
                    jMenuItem2.addActionListener(new OpenNetInstanceAction(remotePlugin.wrapInstance(((NetEvent)simulationEvent).getNetInstance())));
                }
                jPopupMenu.add(jMenuItem2);
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem3 = new JMenuItem("show net pattern element");
                if (simulationEvent instanceof PlaceEvent || simulationEvent instanceof TransitionEvent) {
                    if (simulationEvent instanceof PlaceEvent) {
                        jMenuItem3.addActionListener(new OpenNetPatternElementAction(remotePlugin.wrapInstance(((PlaceEvent)simulationEvent).getPlaceInstance())));
                    } else {
                        jMenuItem3.addActionListener(new OpenNetPatternElementAction(remotePlugin.wrapInstance(((TransitionEvent)simulationEvent).getTransitionInstance())));
                    }
                } else {
                    jMenuItem3.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem3);
                JMenuItem jMenuItem4 = new JMenuItem("show net instance element");
                if (simulationEvent instanceof PlaceEvent || simulationEvent instanceof TransitionEvent) {
                    if (simulationEvent instanceof PlaceEvent) {
                        jMenuItem4.addActionListener(new OpenNetInstanceElementAction(remotePlugin.wrapInstance(((PlaceEvent)simulationEvent).getPlaceInstance())));
                    } else {
                        jMenuItem4.addActionListener(new OpenNetInstanceElementAction(remotePlugin.wrapInstance(((TransitionEvent)simulationEvent).getTransitionInstance())));
                    }
                } else {
                    jMenuItem4.setEnabled(false);
                }
                jPopupMenu.add(jMenuItem4);
            } else {
                JMenuItem jMenuItem = new JMenuItem("Simulation terminated");
                jMenuItem.setEnabled(false);
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
        }

        private void openDetailView(JTable jTable, MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = jTable.rowAtPoint(point);
            StepTableModel stepTableModel = (StepTableModel)jTable.getModel();
            SimulationEvent simulationEvent = (SimulationEvent)stepTableModel.getValueAt(n, 0);
            JFrame jFrame = new JFrame();
            jFrame.setSize(600, 300);
            jFrame.getContentPane().setLayout(new BorderLayout());
            JTextArea jTextArea = new JTextArea(simulationEvent.toString());
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            jFrame.setVisible(true);
        }

        private class OpenNetInstanceElementAction
        implements ActionListener {
            private Object elementInstance;

            public OpenNetInstanceElementAction(PlaceInstanceAccessor placeInstanceAccessor) {
                this.elementInstance = placeInstanceAccessor;
            }

            public OpenNetInstanceElementAction(TransitionInstanceAccessor transitionInstanceAccessor) {
                this.elementInstance = transitionInstanceAccessor;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PlaceInstanceAccessor placeInstanceAccessor;
                    NetInstanceAccessor netInstanceAccessor = null;
                    NetElementID netElementID = null;
                    if (this.elementInstance instanceof PlaceInstanceAccessor) {
                        placeInstanceAccessor = (PlaceInstanceAccessor)this.elementInstance;
                        netInstanceAccessor = placeInstanceAccessor.getNetInstance();
                        netElementID = placeInstanceAccessor.getID();
                    } else if (this.elementInstance instanceof TransitionInstanceAccessor) {
                        placeInstanceAccessor = (TransitionInstanceAccessor)this.elementInstance;
                        netInstanceAccessor = placeInstanceAccessor.getNetInstance();
                        netElementID = placeInstanceAccessor.getID();
                    }
                    int n = 0;
                    if (netElementID != null) {
                        n = netElementID.getFigureID();
                    }
                    GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                    CPNApplication cPNApplication = guiPlugin.getGui();
                    cPNApplication.openInstanceDrawing(netInstanceAccessor);
                    CPNInstanceDrawing cPNInstanceDrawing = CPNInstanceDrawing.getInstanceDrawing((NetInstanceAccessor)netInstanceAccessor);
                    if (cPNInstanceDrawing != null && n != 0) {
                        InstanceFigure instanceFigure = cPNInstanceDrawing.getInstanceFigureOfFigureWithID(n);
                        DrawingView drawingView = cPNApplication.getView((Drawing)cPNInstanceDrawing);
                        if (instanceFigure != null && drawingView != null) {
                            drawingView.clearSelection();
                            drawingView.addToSelection((Figure)instanceFigure);
                            drawingView.repairDamage();
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }

        private class OpenNetPatternElementAction
        implements ActionListener {
            private Object elementInstance;

            public OpenNetPatternElementAction(PlaceInstanceAccessor placeInstanceAccessor) {
                this.elementInstance = placeInstanceAccessor;
            }

            public OpenNetPatternElementAction(TransitionInstanceAccessor transitionInstanceAccessor) {
                this.elementInstance = transitionInstanceAccessor;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PlaceInstanceAccessor placeInstanceAccessor;
                    NetInstanceAccessor netInstanceAccessor = null;
                    NetElementID netElementID = null;
                    if (this.elementInstance instanceof PlaceInstanceAccessor) {
                        placeInstanceAccessor = (PlaceInstanceAccessor)this.elementInstance;
                        netInstanceAccessor = placeInstanceAccessor.getNetInstance();
                        netElementID = placeInstanceAccessor.getID();
                    } else if (this.elementInstance instanceof TransitionInstanceAccessor) {
                        placeInstanceAccessor = (TransitionInstanceAccessor)this.elementInstance;
                        netInstanceAccessor = placeInstanceAccessor.getNetInstance();
                        netElementID = placeInstanceAccessor.getID();
                    }
                    int n = 0;
                    if (netElementID != null) {
                        n = netElementID.getFigureID();
                    }
                    GuiPlugin guiPlugin = GuiPlugin.getCurrent();
                    CPNApplication cPNApplication = guiPlugin.getGui();
                    if (netInstanceAccessor != null) {
                        String string = netInstanceAccessor.getNet().getName();
                        cPNApplication.openNetPatternDrawing(string, n);
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }

        private class OpenNetPatternAction
        implements ActionListener {
            private NetInstanceAccessor netInstance;

            public OpenNetPatternAction(NetInstanceAccessor netInstanceAccessor) {
                this.netInstance = netInstanceAccessor;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GuiPlugin.getCurrent().getGui().openNetPatternDrawing(this.netInstance.getNet().getName());
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }

        private class OpenNetInstanceAction
        implements ActionListener {
            private NetInstanceAccessor netInstance;

            public OpenNetInstanceAction(NetInstanceAccessor netInstanceAccessor) {
                this.netInstance = netInstanceAccessor;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GuiPlugin.getCurrent().getGui().openInstanceDrawing(this.netInstance);
            }
        }
    }
}

