/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.engine.common.SimulatorEvent;
import de.renew.engine.common.StepIdentifier;
import de.renew.gui.logging.AbstractRepository;
import de.renew.gui.logging.LoggerRepository;
import de.renew.gui.logging.StepTrace;
import de.renew.gui.logging.StepTraceChangeListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class MainRepository
extends AbstractRepository
implements StepTraceChangeListener {
    private Map<String, LoggerRepository> loggerRepositories = new Hashtable<String, LoggerRepository>();
    private Map<StepIdentifier, StepTrace> stepTraces = new Hashtable<StepIdentifier, StepTrace>();

    public LoggerRepository getLoggerRepository(String string, int n) {
        LoggerRepository loggerRepository = this.loggerRepositories.get(string);
        if (loggerRepository == null) {
            loggerRepository = new LoggerRepository(this, n);
            this.loggerRepositories.put(string, loggerRepository);
            this.addRepositoryChangeListener(loggerRepository);
        }
        loggerRepository.setCapacity(n);
        return loggerRepository;
    }

    @Override
    public void addEvent(SimulatorEvent simulatorEvent) {
        StepTrace stepTrace = this.stepTraces.get(simulatorEvent.getStep());
        if (stepTrace == null) {
            stepTrace = new StepTrace(simulatorEvent.getStep());
            stepTrace.addStepTraceChangeListener(this);
            this.stepTraces.put(simulatorEvent.getStep(), stepTrace);
            this.fireStepTraceAdded(stepTrace);
        }
        stepTrace.log(simulatorEvent.getMessage());
    }

    @Override
    public StepTrace[] getStepTraces(StepIdentifier[] stepIdentifierArray) {
        Vector<StepTrace> vector = new Vector<StepTrace>();
        for (int i = 0; i < stepIdentifierArray.length; ++i) {
            StepTrace stepTrace = this.stepTraces.get(stepIdentifierArray[i]);
            if (stepTrace == null) continue;
            vector.add(stepTrace);
        }
        return vector.toArray(new StepTrace[0]);
    }

    @Override
    public StepTrace[] getAllStepTraces() {
        return this.stepTraces.entrySet().toArray(new StepTrace[0]);
    }

    @Override
    public StepTrace getStepTrace(StepIdentifier stepIdentifier) {
        StepTrace stepTrace = this.stepTraces.get(stepIdentifier);
        return stepTrace;
    }

    @Override
    public boolean removeStepTrace(StepIdentifier stepIdentifier) {
        StepTrace stepTrace = this.getStepTrace(stepIdentifier);
        if (stepTrace != null && !this.fireStepTraceRemoveRequest(stepTrace)) {
            this.stepTraces.remove(stepIdentifier);
            return true;
        }
        return false;
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        this.fireStepTraceChanged(stepTrace);
    }
}

