/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.SimulatorEvent;
import de.renew.engine.common.StepIdentifier;
import de.renew.gui.logging.MainRepository;
import de.renew.gui.logging.StepTraceRepository;
import java.util.Vector;

public class MainRepositoryManager {
    private static MainRepositoryManager manager = null;
    private long[] simulationRunIds;
    private MainRepository[] repositories;
    private static int defaultSimulationHistoriesDim = 2;

    public MainRepositoryManager() {
        this(defaultSimulationHistoriesDim);
    }

    public MainRepositoryManager(int n) {
        this.simulationRunIds = new long[n];
        this.repositories = new MainRepository[this.simulationRunIds.length];
    }

    public static MainRepositoryManager getInstance() {
        if (manager == null) {
            manager = new MainRepositoryManager();
        }
        return manager;
    }

    public long[] getSimulationRunIds() {
        int n;
        Vector<Long> vector = new Vector<Long>();
        for (n = 0; n < this.simulationRunIds.length && this.repositories[n] != null; ++n) {
            vector.add(new Long(this.simulationRunIds[n]));
        }
        long[] lArray = new long[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            lArray[n] = (Long)vector.get(n);
        }
        return lArray;
    }

    public MainRepository getRepository(long l) {
        for (int i = 0; i < this.repositories.length && this.repositories[i] != null; ++i) {
            if (this.simulationRunIds[i] != l) continue;
            return this.repositories[i];
        }
        MainRepository mainRepository = new MainRepository();
        for (int i = this.repositories.length - 1; i > 0; --i) {
            this.simulationRunIds[i] = this.simulationRunIds[i - 1];
            this.repositories[i] = this.repositories[i - 1];
        }
        this.simulationRunIds[0] = l;
        this.repositories[0] = mainRepository;
        return mainRepository;
    }

    public MainRepository getRepository(SimulatorEvent simulatorEvent) {
        StepIdentifier stepIdentifier = simulatorEvent.getStep();
        if (stepIdentifier != null) {
            long l = stepIdentifier.getSimulationRunId();
            return this.getRepository(l);
        }
        return null;
    }

    public StepTraceRepository getCurrentRepository(String string) {
        long l = SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().currentStepIdentifier().getSimulationRunId();
        return this.getRepository(l).getLoggerRepository(string, -1);
    }
}

