/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.SimulationEvent;
import de.renew.gui.logging.StepTraceChangeListener;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class StepTrace {
    private Vector<SimulationEvent> events = new Vector();
    private Set<StepTraceChangeListener> listeners = new HashSet<StepTraceChangeListener>();
    private StepIdentifier step;

    public StepTrace(StepIdentifier stepIdentifier) {
        this.step = stepIdentifier;
    }

    public void log(SimulationEvent simulationEvent) {
        if (!this.events.contains(simulationEvent)) {
            this.events.add(simulationEvent);
            this.fireStepTraceChanged();
        }
    }

    public SimulationEvent[] getEvents() {
        return this.events.toArray(new SimulationEvent[0]);
    }

    public StepIdentifier getStepIdentifier() {
        return this.step;
    }

    public String toString() {
        return "Simulator Step " + this.step;
    }

    public void addStepTraceChangeListener(StepTraceChangeListener stepTraceChangeListener) {
        this.listeners.add(stepTraceChangeListener);
    }

    public void fireStepTraceChanged() {
        StepTraceChangeListener[] stepTraceChangeListenerArray = this.listeners.toArray(new StepTraceChangeListener[0]);
        for (int i = 0; i < stepTraceChangeListenerArray.length; ++i) {
            stepTraceChangeListenerArray[i].stepTraceChanged(this);
        }
    }
}

