/*
 * Decompiled with CFR 0.152.
 */
package de.renew.application;

import de.renew.application.NoSimulationException;
import de.renew.application.SimulationControlCommand;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulationRunningException;
import de.renew.application.SimulatorExtension;
import de.renew.application.StartSimulationCommand;
import de.renew.database.SetupHelper;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.engine.simulator.ConcurrentSimulator;
import de.renew.engine.simulator.InheritableSimulationThreadLock;
import de.renew.engine.simulator.NonConcurrentSimulator;
import de.renew.engine.simulator.ParallelSimulator;
import de.renew.engine.simulator.SequentialSimulator;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.engine.simulator.Simulator;
import de.renew.engine.simulator.SimulatorEventQueue;
import de.renew.net.IDRegistry;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetNotFoundException;
import de.renew.net.loading.Finder;
import de.renew.net.loading.NetLoader;
import de.renew.net.loading.PathlessFinder;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.PropertyHelper;
import de.renew.plugin.command.CLCommand;
import de.renew.shadow.DefaultCompiledNetLoader;
import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.shadow.SNSFinder;
import de.renew.shadow.SequentialOnlyExtension;
import de.renew.shadow.ShadowLookup;
import de.renew.shadow.ShadowNetLoader;
import de.renew.shadow.ShadowNetSystem;
import de.renew.shadow.SyntaxException;
import de.renew.util.ClassSource;
import de.renew.util.RenewObjectInputStream;
import de.renew.util.RenewObjectOutputStream;
import de.renew.util.SingletonException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SimulatorPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(SimulatorPlugin.class);
    private static Object singletonLock = new Object();
    private static SimulatorPlugin singleton = null;
    private Queue<SimulatorExtension> extensions = new ConcurrentLinkedQueue<SimulatorExtension>();
    private SimulationEnvironment currentSimulation = null;
    private boolean virginSimulation;
    private DefaultShadowNetLoader currentShadowNetLoader = null;
    private NetLoader nextNetLoader = null;
    private Set<Finder> registeredFinders = Collections.synchronizedSet(new HashSet());
    private Set<PathlessFinder> registeredPathlessFinders = new HashSet<PathlessFinder>();
    private boolean previousClassReinit = false;
    private SimulationThreadPool simulationPool;
    public static final InheritableSimulationThreadLock lock = new InheritableSimulationThreadLock();
    private static final int STATE_STREAM_VERSION = 9;
    private static final String STATE_STREAM_LABEL = "RenewState";
    public static final String MODE_PROP_NAME = "de.renew.simulatorMode";
    public static final String PRIORITY_PROP_NAME = "de.renew.simulatorPriority";
    public static final String MULTIPLICITY_PROP_NAME = "de.renew.simulatorMultiplicity";
    public static final String CLASS_PROP_NAME = "de.renew.simulatorClass";
    public static final String EAGER_PROP_NAME = "de.renew.eagerSimulation";
    public static final String REINIT_PROP_NAME = "de.renew.classReinit";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimulatorPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
        Object object = singletonLock;
        synchronized (object) {
            if (singleton != null) {
                throw new SingletonException("At most one instance of SimulatorPlugin is allowed.");
            }
            singleton = this;
        }
        this.simulationPool = SimulationThreadPool.getCurrent();
    }

    private void checkSingleton() {
        if (singleton != this) {
            throw new SingletonException();
        }
    }

    private void checkSimulation() throws NoSimulationException {
        if (this.currentSimulation == null || this.currentSimulation.getSimulator() == null) {
            throw new NoSimulationException();
        }
    }

    private void checkNoSimulation() throws SimulationRunningException {
        if (this.currentSimulation != null) {
            throw new SimulationRunningException();
        }
    }

    public void init() {
        this.checkSingleton();
        this.setDefaultNetLoader();
        this.registerDefaultNetFinder(new SNSFinder());
        PluginManager.getInstance().addCLCommand("startsimulation", (CLCommand)new StartSimulationCommand(this));
        PluginManager.getInstance().addCLCommand("simulation", (CLCommand)new SimulationControlCommand(this));
    }

    public void addExtension(SimulatorExtension simulatorExtension) {
        this.checkSingleton();
        logger.debug((Object)("SimulatorPlugin: Registering extension " + simulatorExtension + "."));
        this.extensions.add(simulatorExtension);
    }

    public void removeExtension(SimulatorExtension simulatorExtension) {
        this.checkSingleton();
        logger.debug((Object)("SimulatorPlugin: Deregistering extension " + simulatorExtension + "."));
        this.extensions.remove(simulatorExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupSimulation(final Properties properties) {
        this.checkSingleton();
        lock.lock();
        try {
            SimulationThreadPool.getNew().executeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    try {
                        SimulatorPlugin.this.checkNoSimulation();
                    }
                    catch (SimulationRunningException simulationRunningException) {
                        SimulationThreadPool.discardNew();
                        throw simulationRunningException;
                    }
                    SimulatorPlugin.this.restartThreadPool();
                    assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                    Properties properties2 = new Properties();
                    properties2.putAll((Map<?, ?>)SimulatorPlugin.this.getProperties());
                    if (properties != null) {
                        properties2.putAll((Map<?, ?>)properties);
                    }
                    int n = PropertyHelper.getIntProperty((Properties)properties2, (String)SimulatorPlugin.PRIORITY_PROP_NAME, (int)5);
                    if (SimulatorPlugin.this.simulationPool.getMaxPriority() != n) {
                        SimulatorPlugin.this.simulationPool.setMaxPriority(n);
                    }
                    SimulatorEventQueue.initialize();
                    logger.debug((Object)"SimulatorPlugin: Setting up simulation.");
                    SimulatorExtension[] simulatorExtensionArray = SimulatorPlugin.this.extensions.toArray(new SimulatorExtension[SimulatorPlugin.this.extensions.size()]);
                    SimulatorPlugin.this.possiblySetupClassSource(properties2);
                    Net.forgetAllNets();
                    Net.setNetLoader(SimulatorPlugin.this.nextNetLoader);
                    if (SimulatorPlugin.this.nextNetLoader instanceof DelayedDelegationNetLoader) {
                        object = SimulatorPlugin.this.registeredFinders;
                        synchronized (object) {
                            logger.debug((Object)"SimulatorPlugin: Creating default shadow net loader.");
                            SimulatorPlugin.this.currentShadowNetLoader = new DefaultShadowNetLoader(properties2);
                            for (Object object2 : SimulatorPlugin.this.registeredFinders) {
                                SimulatorPlugin.this.currentShadowNetLoader.registerFinder((Finder)object2);
                            }
                            for (Object object2 : SimulatorPlugin.this.registeredPathlessFinders) {
                                SimulatorPlugin.this.currentShadowNetLoader.registerPathlessFinder((PathlessFinder)object2);
                            }
                        }
                        logger.debug((Object)"SimulatorPlugin: Configuring delayed net loader.");
                        ((DelayedDelegationNetLoader)SimulatorPlugin.this.nextNetLoader).setNetLoader(new DefaultCompiledNetLoader(SimulatorPlugin.this.currentShadowNetLoader));
                    }
                    object = SimulatorPlugin.newSimulator(properties2);
                    SimulatorPlugin.this.currentSimulation = new SimulationEnvironment((Simulator)object, simulatorExtensionArray, properties2);
                    SimulatorPlugin.this.virginSimulation = true;
                    for (int i = 0; i < simulatorExtensionArray.length; ++i) {
                        simulatorExtensionArray[i].simulationSetup(SimulatorPlugin.this.currentSimulation);
                    }
                    PluginManager.getInstance().blockExit((IPlugin)SimulatorPlugin.getCurrent());
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    private static Simulator newSimulator(final Properties properties) {
        Future<Simulator> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<Simulator>(){

            @Override
            public Simulator call() throws Exception {
                Simulator simulator;
                int n = PropertyHelper.getIntProperty((Properties)properties, (String)SimulatorPlugin.MODE_PROP_NAME, (int)1);
                int n2 = PropertyHelper.getIntProperty((Properties)properties, (String)SimulatorPlugin.MULTIPLICITY_PROP_NAME, (int)1);
                Class clazz = PropertyHelper.getClassProperty((Properties)properties, (String)SimulatorPlugin.CLASS_PROP_NAME, Simulator.class);
                if (clazz != null) {
                    logger.debug((Object)("Using simulator class " + clazz.getName() + " with " + n2 + " simulators ..."));
                }
                if (clazz == null) {
                    n2 = n;
                    if (n2 == 0 || n2 == -1) {
                        n2 = 0;
                        logger.info((Object)"Using sequential simulator ...");
                        clazz = NonConcurrentSimulator.class;
                    } else if (n2 < -1) {
                        logger.warn((Object)("Using " + -n2 + " sequential simulators ..."));
                        logger.warn((Object)"Caution! This is an experimental feature!");
                        clazz = ParallelSimulator.class;
                    } else if (n2 > 1) {
                        logger.warn((Object)("Using " + n2 + " concurrent simulators ..."));
                        logger.warn((Object)"Caution! This is an experimental feature!");
                        clazz = ParallelSimulator.class;
                    } else {
                        clazz = ConcurrentSimulator.class;
                        logger.info((Object)"Using default concurrent simulator ...");
                    }
                }
                assert (clazz != null) : "Simulator class not determined.Properties were: Mode=" + properties.getProperty("de.renew.simulatorMode") + " Multiplicity=" + properties.getProperty("de.renew.simulatorMultiplicity") + " Class=" + properties.getProperty("de.renew.simulatorClass");
                boolean bl = PropertyHelper.getBoolProperty((Properties)properties, (String)SimulatorPlugin.EAGER_PROP_NAME);
                if (bl) {
                    logger.info((Object)"Using eager simulation mode.");
                }
                if (SequentialSimulator.class.equals(clazz)) {
                    simulator = new SequentialSimulator(!bl);
                    n2 = 0;
                } else if (NonConcurrentSimulator.class.equals(clazz)) {
                    simulator = new NonConcurrentSimulator(!bl);
                    n2 = 0;
                } else if (ConcurrentSimulator.class.equals(clazz)) {
                    simulator = new ConcurrentSimulator(!bl);
                    n2 = 1;
                } else if (ParallelSimulator.class.equals(clazz)) {
                    simulator = new ParallelSimulator(n2, !bl);
                } else {
                    logger.error((Object)"Sorry, only known simulators can be instantiated for the time being.");
                    simulator = new ConcurrentSimulator(!bl);
                    clazz = ConcurrentSimulator.class;
                    n2 = 1;
                }
                assert (simulator != null) : "Simulator has not been set!?";
                properties.setProperty(SimulatorPlugin.CLASS_PROP_NAME, clazz.getName());
                properties.setProperty(SimulatorPlugin.MULTIPLICITY_PROP_NAME, Integer.toString(n2));
                return simulator;
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSimulationActive() {
        Boolean bl;
        this.checkSingleton();
        Object object = new Object();
        synchronized (object) {
            bl = this.currentSimulation != null && this.currentSimulation.getSimulator().isActive();
        }
        return bl;
    }

    public SimulationEnvironment getCurrentEnvironment() {
        return this.currentSimulation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShadowLookup insertNets(final ShadowNetSystem shadowNetSystem) throws SyntaxException, NoSimulationException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<ShadowLookup> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<ShadowLookup>(){

                @Override
                public ShadowLookup call() throws SyntaxException, NoSimulationException {
                    ShadowLookup shadowLookup;
                    SimulatorPlugin.this.checkSimulation();
                    if (shadowNetSystem == null) {
                        throw new NullPointerException("Missing shadow net system.");
                    }
                    ShadowNetLoader shadowNetLoader = shadowNetSystem.getNetLoader();
                    if (shadowNetLoader == null && SimulatorPlugin.this.currentShadowNetLoader != null) {
                        logger.debug((Object)"SimulatorPlugin: Applying default shadow net loader to net system.");
                        shadowNetSystem.setNetLoader(SimulatorPlugin.this.currentShadowNetLoader);
                    }
                    if (SimulatorPlugin.this.virginSimulation) {
                        logger.debug((Object)"SimulatorPlugin: Compiling first net system.");
                        shadowLookup = shadowNetSystem.compile();
                    } else {
                        logger.debug((Object)"SimulatorPlugin: Adding another net system.");
                        shadowLookup = shadowNetSystem.compileMore();
                    }
                    logger.debug((Object)("SimulatorPlugin: Compilation result lookup: " + shadowLookup));
                    SequentialOnlyExtension sequentialOnlyExtension = SequentialOnlyExtension.lookup(shadowLookup);
                    boolean bl = sequentialOnlyExtension.getSequentialOnly();
                    if (bl && !SimulatorPlugin.this.currentSimulation.getSimulator().isSequential()) {
                        throw new SyntaxException("Some nets need a sequential simulator.");
                    }
                    SimulatorPlugin.this.virginSimulation = false;
                    SimulatorExtension[] simulatorExtensionArray = SimulatorPlugin.this.currentSimulation.getExtensions();
                    for (int i = 0; i < simulatorExtensionArray.length; ++i) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(SimulatorPlugin.class.getName() + ": Active Extension compile net " + simulatorExtensionArray[i].toString()));
                        }
                        simulatorExtensionArray[i].netsCompiled(shadowLookup);
                    }
                    shadowLookup.makeNetsKnown();
                    return shadowLookup;
                }
            });
            ShadowLookup shadowLookup = future.get();
            return shadowLookup;
        }
        catch (InterruptedException interruptedException) {
            logger.info((Object)"Simulation ended");
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof SyntaxException) {
                throw (SyntaxException)throwable;
            }
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetupHelper.SimulationState restoreStateFromDatabase() {
        this.checkSingleton();
        lock.lock();
        try {
            Future<SetupHelper.SimulationState> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<SetupHelper.SimulationState>(){

                @Override
                public SetupHelper.SimulationState call() throws NoSimulationException {
                    SimulatorPlugin.this.checkSimulation();
                    SetupHelper.SimulationState simulationState = SetupHelper.setup(SimulatorPlugin.this.currentSimulation.getProperties());
                    return simulationState;
                }
            });
            SetupHelper.SimulationState simulationState = future.get();
            return simulationState;
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(final ObjectOutput objectOutput, final NetInstance[] netInstanceArray) throws IOException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<Object> future = this.simulationPool.submitAndWait(new Callable<Object>(){

                @Override
                public Object call() throws IOException, NoSimulationException {
                    SimulatorPlugin.this.checkSimulation();
                    SimulatorPlugin.this.currentSimulation.getSimulator().stopRun();
                    RenewObjectOutputStream renewObjectOutputStream = null;
                    if (objectOutput instanceof RenewObjectOutputStream) {
                        renewObjectOutputStream = (RenewObjectOutputStream)objectOutput;
                    }
                    if (renewObjectOutputStream != null) {
                        renewObjectOutputStream.beginDomain(SimulatorPlugin.class);
                    }
                    objectOutput.writeObject(SimulatorPlugin.STATE_STREAM_LABEL);
                    objectOutput.writeInt(9);
                    objectOutput.writeInt(PropertyHelper.getIntProperty((Properties)SimulatorPlugin.this.currentSimulation.getProperties(), (String)SimulatorPlugin.MULTIPLICITY_PROP_NAME));
                    objectOutput.writeInt(netInstanceArray.length);
                    for (int i = 0; i < netInstanceArray.length; ++i) {
                        objectOutput.writeObject(netInstanceArray[i]);
                    }
                    if (renewObjectOutputStream != null) {
                        renewObjectOutputStream.writeDelayedObjects();
                    }
                    Net.saveAllNets(objectOutput);
                    SearchQueue.saveQueue(objectOutput);
                    IDRegistry.save(objectOutput);
                    if (renewObjectOutputStream != null) {
                        renewObjectOutputStream.endDomain(SimulatorPlugin.class);
                    }
                    return null;
                }
            });
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetInstance[] loadState(final ObjectInput objectInput, final Properties properties) throws IOException, ClassNotFoundException, SimulationRunningException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<NetInstance[]> future = SimulationThreadPool.getNew().submitAndWait(new Callable<NetInstance[]>(){

                @Override
                public NetInstance[] call() throws IOException, ClassNotFoundException, SimulationRunningException {
                    ArrayList<NetInstance> arrayList;
                    try {
                        logger.debug((Object)"Loading simulation state...");
                        SimulatorPlugin.this.setupSimulation(properties);
                        String string = (String)objectInput.readObject();
                        if (!string.equals(SimulatorPlugin.STATE_STREAM_LABEL)) {
                            throw new StreamCorruptedException("Stream does not seem to contain renew state data.");
                        }
                        int n = objectInput.readInt();
                        if (n != 9) {
                            throw new StreamCorruptedException("State data is of different version (" + n + ") than the current version (" + 9 + ").");
                        }
                        int n2 = PropertyHelper.getIntProperty((Properties)SimulatorPlugin.this.currentSimulation.getProperties(), (String)SimulatorPlugin.MULTIPLICITY_PROP_NAME, (int)1);
                        int n3 = objectInput.readInt();
                        if (n3 != n2) {
                            logger.warn((Object)("Simulation state was saved using a different simulator multiplicity (" + n3 + ") " + "than currently selected (" + n2 + ")."));
                        }
                        int n4 = objectInput.readInt();
                        arrayList = new ArrayList<NetInstance>(n4);
                        try {
                            for (int i = 0; i < n4; ++i) {
                                arrayList.add((NetInstance)ClassSource.readObject((ObjectInput)objectInput));
                            }
                        }
                        catch (ClassCastException classCastException) {
                            logger.debug((Object)classCastException.getMessage(), (Throwable)classCastException);
                            throw new StreamCorruptedException("Object other than NetInstance found when looking for net instances: " + classCastException.getMessage());
                        }
                        if (objectInput instanceof RenewObjectInputStream) {
                            ((RenewObjectInputStream)objectInput).readDelayedObjects();
                        }
                        Net.loadNets(objectInput);
                        SearchQueue.loadQueue(objectInput);
                        IDRegistry.load(objectInput);
                    }
                    catch (SimulationRunningException simulationRunningException) {
                        throw simulationRunningException;
                    }
                    catch (IOException iOException) {
                        SimulatorPlugin.this.terminateSimulation();
                        throw iOException;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        SimulatorPlugin.this.terminateSimulation();
                        throw classNotFoundException;
                    }
                    catch (StackOverflowError stackOverflowError) {
                        SimulatorPlugin.this.terminateSimulation();
                        throw stackOverflowError;
                    }
                    return arrayList.toArray(new NetInstance[arrayList.size()]);
                }
            });
            NetInstance[] netInstanceArray = future.get();
            return netInstanceArray;
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof SimulationRunningException) {
                throw new SimulationRunningException(executionException);
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof ClassNotFoundException) {
                throw new ClassNotFoundException(throwable.getMessage(), executionException);
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public synchronized void setNetLoader(NetLoader netLoader) {
        this.checkSingleton();
        logger.debug((Object)("SimulatorPlugin: Configuring net loader " + netLoader + "."));
        this.nextNetLoader = netLoader;
    }

    public synchronized void setDefaultNetLoader() {
        this.setNetLoader(new DelayedDelegationNetLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefaultNetFinder(Finder finder) {
        Set<Finder> set = this.registeredFinders;
        synchronized (set) {
            this.registeredFinders.add(finder);
            if (this.currentShadowNetLoader != null) {
                this.currentShadowNetLoader.registerFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefaultNetFinder(Finder finder) {
        Set<Finder> set = this.registeredFinders;
        synchronized (set) {
            this.registeredFinders.remove(finder);
            if (this.currentShadowNetLoader != null) {
                this.currentShadowNetLoader.removeFinder(finder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDefaultPathlessFinder(PathlessFinder pathlessFinder) {
        Set<Finder> set = this.registeredFinders;
        synchronized (set) {
            this.registeredPathlessFinders.add(pathlessFinder);
            if (this.currentShadowNetLoader != null) {
                this.currentShadowNetLoader.registerPathlessFinder(pathlessFinder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDefaultPathlessFinder(PathlessFinder pathlessFinder) {
        Set<Finder> set = this.registeredFinders;
        synchronized (set) {
            this.registeredFinders.remove(pathlessFinder);
            if (this.currentShadowNetLoader != null) {
                this.currentShadowNetLoader.removePathlessFinder(pathlessFinder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetInstance createNetInstance(final String string) throws NetNotFoundException, NoSimulationException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<NetInstance> future = SimulationThreadPool.getCurrent().submitAndWait(new Callable<NetInstance>(){

                @Override
                public NetInstance call() throws NetNotFoundException, NoSimulationException {
                    Net net;
                    NetInstance netInstance = null;
                    SimulatorPlugin.this.checkSimulation();
                    if (string != null && (net = Net.forName(string)) != null) {
                        netInstance = net.buildInstance(SimulatorPlugin.this.currentSimulation.getSimulator().nextStepIdentifier());
                        SimulatorPlugin.this.currentSimulation.getSimulator().refresh();
                    }
                    return netInstance;
                }
            });
            NetInstance netInstance = future.get();
            return netInstance;
        }
        catch (InterruptedException interruptedException) {
            logger.info((Object)"Creation of NetInstances was aborted");
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof NetNotFoundException) {
                throw (NetNotFoundException)throwable;
            }
            if (throwable instanceof NoSimulationException) {
                throw (NoSimulationException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateSimulation() {
        this.checkSingleton();
        lock.lock();
        try {
            SimulationThreadPool.getCurrent().executeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (SimulatorPlugin.this.currentSimulation != null) {
                        int n;
                        logger.debug((Object)"SimulatorPlugin: Stopping simulation.");
                        SimulatorExtension[] simulatorExtensionArray = SimulatorPlugin.this.currentSimulation.getExtensions();
                        for (n = 0; n < simulatorExtensionArray.length; ++n) {
                            simulatorExtensionArray[n].simulationTerminating();
                        }
                        SimulatorPlugin.this.currentSimulation.getSimulator().terminateRun();
                        simulatorExtensionArray = SimulatorPlugin.this.currentSimulation.getExtensions();
                        for (n = 0; n < simulatorExtensionArray.length; ++n) {
                            simulatorExtensionArray[n].simulationTerminated();
                        }
                        SearchQueue.reset(0.0);
                        IDRegistry.reset();
                        Net.forgetAllNets();
                        PluginManager.getInstance().exitOk((IPlugin)SimulatorPlugin.getCurrent());
                        SimulatorPlugin.this.currentSimulation = null;
                        SimulatorPlugin.this.currentShadowNetLoader = null;
                    }
                }
            });
        }
        finally {
            lock.unlock();
        }
    }

    private void restartThreadPool() {
        SimulationThreadPool.cleanup();
        this.simulationPool = SimulationThreadPool.getSimulationThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean cleanup() {
        Object object = singletonLock;
        synchronized (object) {
            this.checkSingleton();
            this.terminateSimulation();
            singleton = null;
        }
        return true;
    }

    public synchronized boolean canShutDown() {
        this.checkSingleton();
        return true;
    }

    public Object submitAndWait(Callable callable) {
        this.checkSingleton();
        this.checkSimulation();
        return this.simulationPool.submitAndWait(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void possiblySetupClassSource(final Properties properties) throws IllegalStateException {
        this.checkSingleton();
        lock.lock();
        try {
            Future<Object> future = this.simulationPool.submitAndWait(new Callable<Object>(){

                @Override
                public Object call() throws IllegalStateException {
                    if (SimulatorPlugin.this.isSimulationActive()) {
                        throw new IllegalStateException("Reconfiguration of class source is not allowed while a simulation is running.");
                    }
                    boolean bl = PropertyHelper.getBoolProperty((Properties)properties, (String)SimulatorPlugin.REINIT_PROP_NAME);
                    if (bl) {
                        if (bl != SimulatorPlugin.this.previousClassReinit) {
                            logger.info((Object)"Using classReinit mode.");
                        } else {
                            logger.debug((Object)"SimulatorPlugin: Re-initialising class loader.");
                        }
                        ClassLoader classLoader = PluginManager.getInstance().getNewBottomClassLoader();
                        ClassSource.setClassLoader((ClassLoader)classLoader);
                    } else if (SimulatorPlugin.this.previousClassReinit) {
                        logger.debug((Object)"classReinit mode disabled.");
                        ClassSource.setClassLoader(null);
                    }
                    SimulatorPlugin.this.previousClassReinit = bl;
                    return null;
                }
            });
            future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof IllegalStateException) {
                throw (IllegalStateException)throwable;
            }
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        finally {
            lock.unlock();
        }
    }

    public static SimulatorPlugin getCurrent() {
        for (IPlugin iPlugin : PluginManager.getInstance().getPluginsProviding("de.renew.simulator")) {
            if (!(iPlugin instanceof SimulatorPlugin)) continue;
            return (SimulatorPlugin)iPlugin;
        }
        return null;
    }

    private class DelayedDelegationNetLoader
    implements NetLoader {
        private NetLoader netLoader = null;

        private DelayedDelegationNetLoader() {
        }

        public void setNetLoader(NetLoader netLoader) {
            this.netLoader = netLoader;
        }

        @Override
        public Net loadNet(String string) throws NetNotFoundException {
            if (this.netLoader == null) {
                throw new NetNotFoundException("No net loader configured.");
            }
            return this.netLoader.loadNet(string);
        }
    }
}

