/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.DatabaseRestoreSource;
import de.renew.database.DatabaseTransactionStrategy;
import de.renew.database.NetInstanceMap;
import de.renew.database.RestoreSource;
import de.renew.database.TransactionSource;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.net.IDRegistry;
import de.renew.net.IDSource;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceImpl;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.TrivialIDFactory;
import de.renew.plugin.PluginManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SetupHelper {
    public static Logger logger = Logger.getLogger(SetupHelper.class);

    private SetupHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetInstanceMap restoreNetInstances(RestoreSource restoreSource) throws Exception {
        PlaceInstance placeInstance;
        Object object;
        Object object2;
        Enumeration<String> enumeration;
        String[] stringArray = restoreSource.getAllNetIDs();
        int n = stringArray.length;
        Net[] netArray = new Net[n];
        NetInstance[] netInstanceArray = new NetInstance[n];
        NetInstanceMap netInstanceMap = new NetInstanceMap();
        for (int i = 0; i < n; ++i) {
            enumeration = stringArray[i];
            object2 = Net.forName(restoreSource.getNetName((String)((Object)enumeration)));
            netArray[i] = object2;
            object = ((Net)object2).buildInstance();
            object.setID((String)((Object)enumeration));
            netInstanceArray[i] = object;
            netInstanceMap.put((String)((Object)enumeration), (NetInstance)object);
            for (Place place : ((Net)object2).places()) {
                placeInstance = object.getInstance(place);
                placeInstance.lock.lock();
                try {
                    placeInstance.extractAllTokens(new Vector<Object>(), new Vector<Double>());
                }
                finally {
                    placeInstance.lock.unlock();
                }
            }
        }
        Hashtable<String, Object> hashtable = restoreSource.getTokens(netInstanceMap);
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = hashtable.get(object2);
            IDRegistry.getInstance().setAndReserveID(object, (String)object2);
        }
        for (int i = 0; i < n; ++i) {
            object = netInstanceArray[i];
            for (Place place : netArray[i].places()) {
                placeInstance = object.getInstance(place);
                placeInstance.lock.lock();
                try {
                    Vector<String> vector = new Vector<String>();
                    restoreSource.fillinAllTokens(placeInstance, vector);
                    int n2 = vector.size();
                    for (int j = 0; j < n2; ++j) {
                        String string = vector.elementAt(j);
                        Object object3 = hashtable.get(string);
                        placeInstance.insertTokenWithID(object3, string, 0.0);
                    }
                }
                finally {
                    placeInstance.lock.unlock();
                }
            }
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            object = hashtable.get(string);
            IDRegistry.getInstance().unreserve(object);
        }
        return netInstanceMap;
    }

    public static SimulationState setup(Properties properties) {
        Object object;
        Object object2;
        Object object3;
        String string = properties.getProperty("de.renew.simdb.driver");
        String string2 = properties.getProperty("de.renew.simdb.dialect");
        String string3 = properties.getProperty("de.renew.simdb.url");
        String string4 = properties.getProperty("de.renew.simdb.user");
        String string5 = properties.getProperty("de.renew.simdb.password");
        if (string3 == null && string == null) {
            return SimulationState.TERMINATED_STATE;
        }
        if (string3 == null || string == null) {
            logger.error((Object)"Error: Specify de.renew.simdb.url and de.renew.simdb.driver system properties together to use a simulation database.");
            return SimulationState.TERMINATED_STATE;
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string2 == null) {
            string2 = "de.renew.database.entitylayer.SQLDialect";
            logger.warn((Object)("The system property de.renew.simdb.dialect has not been specified. Using default dialect " + string2));
        }
        ClassLoader classLoader = PluginManager.getInstance().getBottomClassLoader();
        try {
            object3 = Class.forName(string, true, classLoader);
            object2 = ((Class)object3).getConstructor(new Class[0]);
            ((Constructor)object2).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)("Cannot set simulation database.\nDatabase driver class " + string + " not found."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error((Object)"Cannot set simulation database.\nDatabase driver class's default constructor is not accessable.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)"Cannot set simulation database.\nDatabase driver class's default constructor cannot be invoked.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (InstantiationException instantiationException) {
            logger.error((Object)"Cannot set simulation database.\nDatabase driver class is abstract or an interface.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error((Object)("Cannot set simulation database.\nDatabase driver class's default constructor threw an exception:\n" + invocationTargetException.getTargetException()));
            return SimulationState.TERMINATED_STATE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error((Object)"Cannot set simulation database.\nDatabase driver class has no default constructor.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (SecurityException securityException) {
            logger.error((Object)"Cannot set simulation database.\nDatabase driver class's default constructor is not accessable.");
            return SimulationState.TERMINATED_STATE;
        }
        object3 = null;
        try {
            object2 = Class.forName(string2, true, classLoader);
            object = ((Class)object2).getConstructor(new Class[0]);
            object3 = (SQLDialect)((Constructor)object).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)("Cannot set simulation database.\nSQL dialect class " + string2 + " not found."));
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error((Object)"Cannot set simulation database.\nSQL dialect class's default constructor is not accessable.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error((Object)"Cannot set simulation database.\nSQL dialect class's default constructor cannot be invoked.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (InstantiationException instantiationException) {
            logger.error((Object)"Cannot set simulation database.\nSQL dialect is an abstract class or an interface.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error((Object)("Cannot set simulation database.\nSQL dialect class's default constructor threw an exception:\n" + invocationTargetException.getTargetException()));
            return SimulationState.TERMINATED_STATE;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.error((Object)"Cannot set simulation database.\nSQL dialect class has no default constructor.");
            return SimulationState.TERMINATED_STATE;
        }
        catch (SecurityException securityException) {
            logger.error((Object)"Cannot set simulation database.\nSQL dialect class's default constructor is not accessable.");
            return SimulationState.TERMINATED_STATE;
        }
        object2 = null;
        object = new ArrayList();
        try {
            logger.error((Object)("Connecting to simulation database " + string3 + "..."));
            object2 = string4 != null ? new DatabaseRestoreSource(string3, string4, string5, (SQLDialect)object3) : new DatabaseRestoreSource(string3, (SQLDialect)object3);
            logger.error((Object)"Connected.");
            NetInstanceImpl.useGlobalIDRegistry = true;
            if (((DatabaseRestoreSource)object2).wasSimulationInited()) {
                logger.error((Object)"Loading simulation state...");
                NetInstanceMap netInstanceMap = SetupHelper.restoreNetInstances((RestoreSource)object2);
                IDSource.setFactory(new TrivialIDFactory(((DatabaseRestoreSource)object2).getLastId() + 1));
                String[] stringArray = ((DatabaseRestoreSource)object2).getViewedNetIDs();
                for (int i = 0; i < stringArray.length; ++i) {
                    object.add(netInstanceMap.get(stringArray[i]));
                }
                logger.error((Object)"Simulation state loaded.");
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Cannot load simulation state.\nThere was an exception:");
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            logger.error((Object)"Simulation database abandonned.");
            return SimulationState.TERMINATED_STATE;
        }
        try {
            if (string4 != null) {
                TransactionSource.setStrategy(new DatabaseTransactionStrategy(string3, string4, string5, (SQLDialect)object3));
            } else {
                TransactionSource.setStrategy(new DatabaseTransactionStrategy(string3, (SQLDialect)object3));
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Cannot assign simulation database.\nThere was an exception:");
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            logger.error((Object)"Simulation database abandonned.");
            return SimulationState.TERMINATED_STATE;
        }
        return new SimulationState((List)object, (RestoreSource)object2);
    }

    public static class SimulationState {
        public static final SimulationState TERMINATED_STATE = new SimulationState(Collections.EMPTY_LIST, null);
        private List<NetInstance> netInstances;
        private boolean wasSimulationInitiedFlag;
        private boolean wasSimulationRunningFlag;

        private SimulationState(List<NetInstance> list, RestoreSource restoreSource) {
            this.netInstances = list;
            try {
                this.wasSimulationInitiedFlag = restoreSource != null && restoreSource.wasSimulationInited();
                this.wasSimulationRunningFlag = restoreSource != null && restoreSource.wasSimulationRunning();
            }
            catch (Exception exception) {
                logger.error((Object)"Cannot determine simulation run state:");
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                this.wasSimulationInitiedFlag = false;
                this.wasSimulationRunningFlag = false;
            }
        }

        public List<NetInstance> getNetInstances() {
            return this.netInstances;
        }

        public boolean wasSimulationInited() {
            return this.wasSimulationInitiedFlag;
        }

        public boolean wasSimulationRunning() {
            return this.wasSimulationRunningFlag;
        }
    }
}

