/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.StateEntity;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class SimulationStateDumper {
    private static void dumpTable(Entity entity) throws SQLException {
        System.out.println(entity.getTableName() + ":");
        Vector<Entity> vector = Entity.getEntities(entity);
        Enumeration<Entity> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2 = enumeration.nextElement();
            System.out.println("   " + entity2.toString());
        }
        System.out.println("");
    }

    public static void dumpSimulationState(Connection connection, SQLDialect sQLDialect) throws SQLException {
        SimulationStateDumper.dumpTable(new StateEntity(connection, sQLDialect));
        SimulationStateDumper.dumpTable(new NetInstanceEntity(connection, sQLDialect));
        SimulationStateDumper.dumpTable(new TokenEntity(connection, sQLDialect));
        SimulationStateDumper.dumpTable(new TokenPositionEntity(connection, sQLDialect));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        if (stringArray.length != 3 || stringArray[0].charAt(0) == '-') {
            System.out.println("SimulationStateDumper.\nDisplays the current simulation state in the database.\nThis includes all nets, places, tokens and token positions.\nParameters: <database url> <database driver class> <database dialect class>\nDatabase dialect may be generic, oracle, msql or mysql.");
            System.exit(0);
        }
        try {
            object2 = Class.forName(stringArray[1]);
            object = ((Class)object2).getConstructor(new Class[0]);
            ((Constructor)object).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Error: Database driver class not found.");
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Error: Database driver's default constructor is not accessable.");
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Error: Database driver's default constructor cannot be invoked.");
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Error: Database driver is abstract or an interface.");
            System.exit(1);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("Error: Database driver's default constructor threw an exception:\n" + invocationTargetException.getTargetException());
            System.exit(1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("Error: Database driver has no default constructor.");
            System.exit(1);
        }
        catch (SecurityException securityException) {
            System.out.println("Error: Database driver's default constructor is not accessable.");
            System.exit(1);
        }
        object2 = null;
        try {
            object = Class.forName(stringArray[2]);
            Constructor constructor = ((Class)object).getConstructor(new Class[0]);
            object2 = (SQLDialect)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Error: SQL dialect class not found.");
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Error: SQL dialect's default constructor is not accessable.");
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Error: SQL dialect's default constructor cannot be invoked.");
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Error: SQL dialect is abstract or an interface.");
            System.exit(1);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.out.println("Error: SQL dialect's default constructor threw an exception:\n" + invocationTargetException.getTargetException());
            System.exit(1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.out.println("Error: SQL dialect has no default constructor.");
            System.exit(1);
        }
        catch (SecurityException securityException) {
            System.out.println("Error: SQL dialect's default constructor is not accessable.");
            System.exit(1);
        }
        object = null;
        try {
            try {
                object = DriverManager.getConnection(stringArray[0]);
            }
            catch (SQLException sQLException) {
                System.out.println("Error: Cannot connect to database:\n" + sQLException.toString());
                System.exit(1);
            }
            try {
                SimulationStateDumper.dumpSimulationState((Connection)object, (SQLDialect)object2);
            }
            catch (SQLException sQLException) {
                System.out.println("Error: Exception while dumping:\n" + sQLException.toString());
                System.exit(1);
            }
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
                object = null;
            }
        }
    }
}

