/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.NoSuchEntityException;
import de.renew.database.entitylayer.PrimaryKeyNotUniqueException;
import de.renew.database.entitylayer.SQLDialect;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Entity
implements Cloneable {
    public static final byte NOT_MODIFIED = 0;
    public static final byte MODIFIED = 1;
    public static final byte NEW = 2;
    private static PrintStream messageStream = null;
    private Connection connection;
    private SQLDialect dialect;
    private byte state;
    private Hashtable<String, Object> values;

    public Entity(Connection connection, SQLDialect sQLDialect) {
        this.connection = connection;
        this.dialect = sQLDialect;
        this.clear();
    }

    public void clear() {
        this.values = new Hashtable();
        this.state = (byte)2;
    }

    public Object clone() throws CloneNotSupportedException {
        Entity entity = (Entity)super.clone();
        entity.values = new Hashtable();
        Attribute[] attributeArray = this.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            Object object = this.getValue(attributeArray[i].getName());
            if (object == null) continue;
            entity.values.put(attributeArray[i].getName(), object);
        }
        Attribute[] attributeArray2 = this.getPrimaryKey();
        for (int i = 0; i < attributeArray2.length; ++i) {
            entity.values.remove(attributeArray[i].getName());
        }
        entity.state = (byte)2;
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Statement statement = null;
            try {
                if (this.state != 2) {
                    String string = this.dialect.getDeleteString(this.getTableName(), this.getPrimaryKey(), this.getPrimaryKeyValue());
                    if (messageStream != null) {
                        messageStream.println("Entity: Executing " + string);
                    }
                    statement = this.connection.createStatement();
                    statement.executeUpdate(string);
                    if (messageStream != null) {
                        messageStream.println("Entity: Done.");
                    }
                }
                this.clear();
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    public static void deleteEntities(Entity entity) throws SQLException {
        Entity.deleteEntities(entity, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntities(Entity entity, String string) throws SQLException {
        Class<?> clazz = entity.getClass();
        synchronized (clazz) {
            Statement statement = null;
            try {
                String string2 = entity.getDialect().getDeleteString(entity.getTableName(), string);
                if (messageStream != null) {
                    messageStream.println("Entity: Executing " + string2);
                }
                statement = entity.getConnection().createStatement();
                statement.executeUpdate(string2);
                if (messageStream != null) {
                    messageStream.println("Entity: Done.");
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    public abstract Attribute[] getAttributes();

    public Connection getConnection() {
        return this.connection;
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public static Vector<Entity> getEntities(Entity entity) throws SQLException {
        return Entity.getEntitiesBySelectString(entity, entity.getDialect().getSelectString(entity.getTableName(), entity.getAttributes()));
    }

    public static Vector<Entity> getEntities(Entity entity, String string) throws SQLException {
        return Entity.getEntitiesBySelectString(entity, entity.getDialect().getSelectString(entity.getTableName(), entity.getAttributes(), string));
    }

    public static Vector<Entity> getEntities(Entity entity, String string, String string2) throws SQLException {
        return Entity.getEntitiesBySelectString(entity, entity.getDialect().getSelectString(entity.getTableName(), entity.getAttributes(), string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<Entity> getEntitiesBySelectString(Entity entity, String string) throws SQLException {
        Class<?> clazz = entity.getClass();
        synchronized (clazz) {
            Attribute[] attributeArray = entity.getAttributes();
            Vector<Entity> vector = new Vector<Entity>();
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                if (messageStream != null) {
                    messageStream.println("Entity: Executing " + string);
                }
                statement = entity.getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                if (messageStream != null) {
                    messageStream.println("Entity: Done.");
                }
                while (resultSet.next()) {
                    Entity entity2;
                    try {
                        entity2 = (Entity)entity.clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new IllegalArgumentException("Clone of object template not possible.\nPossibly illegal attribute values?");
                    }
                    entity2.clear();
                    for (int i = 0; i < attributeArray.length; ++i) {
                        Object object = resultSet.getObject(i + 1);
                        if (object == null) continue;
                        if (object instanceof BigDecimal) {
                            entity2.setValue(attributeArray[i].getName(), new Integer(((Number)object).intValue()));
                            continue;
                        }
                        entity2.setValue(attributeArray[i].getName(), object);
                    }
                    entity2.state = 0;
                    vector.addElement(entity2);
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            return vector;
        }
    }

    public abstract Attribute[] getPrimaryKey();

    public Object[] getPrimaryKeyValue() {
        Attribute[] attributeArray = this.getPrimaryKey();
        Object[] objectArray = new Object[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            objectArray[i] = this.values.get(attributeArray[i].getName());
        }
        return objectArray;
    }

    public byte getState() {
        return this.state;
    }

    public abstract String getTableName();

    public Object getValue(String string) {
        Object object = this.values.get(string);
        if (object != null && object instanceof byte[]) {
            return new String((byte[])object);
        }
        return object;
    }

    public void load(Object object) throws SQLException {
        this.load(new Object[]{object});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Object[] objectArray) throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Attribute[] attributeArray = this.getAttributes();
            Attribute[] attributeArray2 = this.getPrimaryKey();
            if (objectArray.length != attributeArray2.length) {
                throw new IllegalArgumentException("Wrong number of primary key values supplied.");
            }
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string = this.dialect.getSelectStringWithPrimaryKey(this.getTableName(), attributeArray, attributeArray2, objectArray);
                if (messageStream != null) {
                    messageStream.println("Entity: Executing " + string);
                }
                statement = this.connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (messageStream != null) {
                    messageStream.println("Entity: Done.");
                }
                if (!resultSet.next()) {
                    throw new NoSuchEntityException("No entity with primary key " + this.dialect.getStringOfAttributesAndValues(attributeArray2, objectArray) + " in table " + this.getTableName() + ".");
                }
                this.clear();
                int n = resultSet.getMetaData().getColumnCount();
                for (int i = 0; i < n; ++i) {
                    Object object = resultSet.getObject(i + 1);
                    if (object == null) continue;
                    if (object instanceof BigDecimal) {
                        this.values.put(attributeArray[i].getName(), new Integer(((Number)object).intValue()));
                        continue;
                    }
                    this.values.put(attributeArray[i].getName(), object);
                }
                if (resultSet.next()) {
                    throw new PrimaryKeyNotUniqueException("Duplicate entity with primary key " + this.dialect.getStringOfAttributesAndValues(attributeArray2, objectArray) + " in table " + this.getTableName() + ".");
                }
                this.state = 0;
            }
            catch (SQLException sQLException) {
                this.clear();
                throw sQLException;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws SQLException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Statement statement = null;
            Attribute[] attributeArray = this.getAttributes();
            Attribute[] attributeArray2 = this.getPrimaryKey();
            try {
                switch (this.state) {
                    case 2: {
                        int n = 0;
                        for (int i = 0; i < attributeArray2.length; ++i) {
                            if (this.values.get(attributeArray2[i].getName()) == null) continue;
                            ++n;
                        }
                        if (n > 0 && n < attributeArray2.length) {
                            throw new IllegalStateException("The primary key value is only partially set.\nSet it completely to define its value or set it not at all to let the save method auto-set it.");
                        }
                        if (n < attributeArray2.length) {
                            this.dialect.setUniquePrimaryKeyValueBeforeInsert(this.connection, this, this.values);
                        }
                        String string = this.dialect.getInsertString(this.getTableName(), attributeArray, this.values, attributeArray2);
                        if (n < attributeArray2.length) {
                            this.dialect.setUniquePrimaryKeyValueAfterInsert(this.connection, this, this.values);
                        }
                        if (messageStream != null) {
                            messageStream.println("Entity: Executing " + string);
                        }
                        statement = this.connection.createStatement();
                        statement.executeUpdate(string);
                        if (messageStream == null) break;
                        messageStream.println("Entity: Done.");
                        break;
                    }
                    case 1: {
                        String string = this.dialect.getUpdateString(this.getTableName(), attributeArray, this.values, attributeArray2);
                        if (messageStream != null) {
                            messageStream.println("Entity: Executing " + string);
                        }
                        statement = this.connection.createStatement();
                        statement.executeUpdate(string);
                        if (messageStream == null) break;
                        messageStream.println("Entity: Done.");
                    }
                }
                this.state = 0;
            }
            finally {
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }

    public static void setMessageStream(PrintStream printStream) {
        messageStream = printStream;
    }

    public void setValue(String string, Object object) {
        if (this.state != 2) {
            Attribute[] attributeArray = this.getPrimaryKey();
            for (int i = 0; i < attributeArray.length; ++i) {
                if (!string.equals(attributeArray[i].getName())) continue;
                throw new IllegalArgumentException("It is illegal to change the primary key value of an existing entity.");
            }
        }
        if (object == null) {
            this.values.remove(string);
        } else {
            this.values.put(string, object);
        }
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public String toString() {
        return this.getClass().getName() + "{" + this.dialect.getStringOfAttributesAndValues(this.getAttributes(), this.values) + "}";
    }

    public void touch() {
        if (this.state == 0) {
            this.state = 1;
        }
    }
}

