/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class EntityGenerator {
    private static void generateEntitySource(String string, String string2) throws IOException {
        Vector<Attribute> vector = new Vector<Attribute>();
        Vector<Attribute> vector2 = new Vector<Attribute>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, " ");
            String string4 = "";
            if (stringTokenizer2.hasMoreTokens()) {
                string4 = stringTokenizer2.nextToken().trim();
            }
            String string5 = "";
            if (stringTokenizer2.hasMoreTokens()) {
                string5 = stringTokenizer2.nextToken().trim();
            }
            if (string4.equals("")) continue;
            Attribute attribute = string5.startsWith("INT") || string5.startsWith("NUMBER") ? new Attribute(string4, 1) : (string5.startsWith("REAL") || string5.startsWith("FLOAT") || string5.startsWith("DOUBLE") ? new Attribute(string4, 2) : new Attribute(string4, 3));
            vector.addElement(attribute);
            if (!string4.equals(string + "_ID") && !string4.equals(string + "ID") && !string4.equals("ID")) continue;
            vector2.addElement(attribute);
        }
        EntityGenerator.generateEntitySource(string, vector, vector2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateEntitySource(String string, Vector<Attribute> vector, Vector<Attribute> vector2) throws IOException {
        String string2 = EntityGenerator.sqlStringToJavaString(string, true) + "Entity";
        String string3 = string2 + ".java";
        System.out.println("Generating " + string3 + "...");
        PrintWriter printWriter = null;
        try {
            String string4;
            Attribute attribute;
            Enumeration<Attribute> enumeration;
            File file = new File(string3);
            printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.print("import de.renew.database.entitylayer.*;\nimport java.sql.*;\n\n\n/**\n * The entity class for the table " + string + ".\n" + " */\n" + "public class " + string2 + " extends Entity\n" + "{\n" + "\t// Table specifications\n" + "\t\n" + "\t/**\n" + "\t * The attributes of the entity.\n" + "\t */\n" + "\tprivate static Attribute[] attributes;\n" + "\t\n" + "\t/**\n" + "\t * The primary key of the entity.\n" + "\t */\n" + "\tprivate static Attribute[] primaryKey;\n" + "\t\n" + "\tstatic\n" + "\t{\n" + "\t\tprimaryKey = new Attribute[]\n" + "\t\t{\n");
            boolean bl = true;
            Enumeration<Attribute> enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                enumeration = enumeration2.nextElement();
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(",\n");
                }
                printWriter.print("\t\t\tnew Attribute(\"" + ((Attribute)((Object)enumeration)).getName());
                switch (((Attribute)((Object)enumeration)).getType()) {
                    case 1: {
                        printWriter.print("\", Attribute.TYPE_INT)");
                        break;
                    }
                    case 2: {
                        printWriter.print("\", Attribute.TYPE_REAL)");
                        break;
                    }
                    case 3: {
                        printWriter.print("\", Attribute.TYPE_CHAR)");
                    }
                }
            }
            printWriter.print("\n\t\t};\n\t\n\t\tattributes = new Attribute[]\n\t\t{\n");
            bl = true;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                attribute = (Attribute)enumeration.nextElement();
                if (bl) {
                    bl = false;
                } else {
                    printWriter.print(",\n");
                }
                printWriter.print("\t\t\tnew Attribute(\"" + attribute.getName());
                switch (attribute.getType()) {
                    case 1: {
                        printWriter.print("\", Attribute.TYPE_INT)");
                        break;
                    }
                    case 2: {
                        printWriter.print("\", Attribute.TYPE_REAL)");
                        break;
                    }
                    case 3: {
                        printWriter.print("\", Attribute.TYPE_CHAR)");
                    }
                }
            }
            printWriter.print("\n\t\t};\n\t}\n\n\t/**\n\t * Creates the entity.\n\t * @param connection The connection to\n\t * be used for entity operations.\n\t * @param dialect The SQL dialect to\n\t * be used for entity operations.\n\t */\n\tpublic " + string2 + "(Connection connection, SQLDialect dialect)\n" + "\t{\n" + "\t\tsuper(connection, dialect);\n" + "\t}\n" + "\t\n" + "\t/**\n" + "\t * Returns all attributes of the entity as array.\n" + "\t * @param All attributes as array.\n" + "\t */\n" + "\tpublic Attribute[] getAttributes()\n" + "\t{\n" + "\t\treturn attributes;\n" + "\t}\n" + "\t\n" + "\t/**\n" + "\t * Returns the primary key attributes of the entity.\n" + "\t * @return The primary key attributes.\n" + "\t */\n" + "\tpublic Attribute[] getPrimaryKey()\n" + "\t{\n" + "\t\treturn primaryKey;\n" + "\t}\n" + "\t\n" + "\t/**\n" + "\t * Returns the entity's table name.\n" + "\t * @return The entity's table name.\n" + "\t */\n" + "\tpublic String getTableName()\n" + "\t{\n" + "\t\treturn \"" + string + "\";\n" + "\t}\n" + "\t\n" + "\t// Attribute getter methods\n" + "\t");
            bl = true;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                attribute = enumeration.nextElement();
                string4 = "";
                switch (attribute.getType()) {
                    case 1: {
                        string4 = "Integer";
                        break;
                    }
                    case 2: {
                        string4 = "Double";
                        break;
                    }
                    case 3: {
                        string4 = "String";
                    }
                }
                printWriter.println("\n\t/**\n\t * Returns the value of the attribute " + attribute.getName() + ".\n" + "\t * @return The value of the attribute " + attribute.getName() + ".\n" + "\t */\n" + "\tpublic " + string4 + " get" + EntityGenerator.sqlStringToJavaString(attribute.getName(), true) + "()\n" + "\t{\n" + "\t\treturn (" + string4 + ") getValue(\"" + attribute.getName() + "\");\n" + "\t}");
            }
            printWriter.print("\n\t// Attribute setter methods\n\t");
            bl = true;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                attribute = enumeration.nextElement();
                string4 = "";
                switch (attribute.getType()) {
                    case 1: {
                        string4 = "Integer";
                        break;
                    }
                    case 2: {
                        string4 = "Double";
                        break;
                    }
                    case 3: {
                        string4 = "String";
                    }
                }
                printWriter.println("\n\t/**\n\t * Sets the value of the attribute " + attribute.getName() + ".\n" + "\t * @param " + EntityGenerator.sqlStringToJavaString(attribute.getName(), false) + " The new value for the attribute.\n" + "\t */\n" + "\tpublic void set" + EntityGenerator.sqlStringToJavaString(attribute.getName(), true) + "(" + string4 + " " + EntityGenerator.sqlStringToJavaString(attribute.getName(), false) + ")\n" + "\t{\n" + "\t\tsetValue(\"" + attribute.getName() + "\", " + EntityGenerator.sqlStringToJavaString(attribute.getName(), false) + ");\n" + "\t}");
            }
            printWriter.print("}\n");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static void generateEntities(String string) throws IOException {
        string = string.toUpperCase().trim();
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        string = string.replace('\t', ' ');
        int n = string.indexOf("CREATE TABLE ");
        while (n >= 0) {
            int n2 = (string = string.substring(n += "CREATE TABLE ".length()).trim()).indexOf(" ");
            if (n2 >= 0) {
                String string2 = string.substring(0, n2).trim();
                int n3 = (string = string.substring(n2).trim()).indexOf("(");
                if (n3 >= 0) {
                    int n4;
                    string = string.substring(n3).trim();
                    int n5 = 1;
                    block5: for (n4 = 1; n4 < string.length() && n5 > 0; ++n4) {
                        switch (string.charAt(n4)) {
                            case '(': {
                                ++n5;
                                continue block5;
                            }
                            case ')': {
                                --n5;
                            }
                        }
                    }
                    if (n4 < string.length()) {
                        String string3 = string.substring(1, n4 - 1).trim();
                        EntityGenerator.generateEntitySource(string2, string3);
                        string = string.substring(n4).trim();
                    } else {
                        string = "";
                    }
                    n3 = string.indexOf("(");
                }
                n2 = string.indexOf(" ");
            }
            n = string.indexOf("CREATE TABLE ");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1 || stringArray[0].charAt(0) == '-') {
            System.out.println("EntityGenerator V1.0.\nBuilds entity classes out of create table SQL statements.\nParameters: <SQL script file name>\n");
            System.exit(0);
        }
        File file = new File(stringArray[0]);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream.read(byArray);
        EntityGenerator.generateEntities(new String(byArray));
        fileInputStream.close();
        System.out.print("Remember to add a package information to the entity classes.\n");
    }

    private static String sqlStringToJavaString(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                stringBuffer.append(bl ? Character.toUpperCase(c) : Character.toLowerCase(c));
            }
            bl = !(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z');
        }
        return stringBuffer.toString();
    }
}

