/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.Entity;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class SQLDialect {
    protected String convertStringForDB(String string) {
        int n = string.indexOf("\\");
        while (n >= 0) {
            string = string.substring(0, n) + "\\\\" + string.substring(n + 1);
            n = string.indexOf("\\", n + 2);
        }
        n = string.indexOf("'");
        while (n >= 0) {
            string = string.substring(0, n) + "\\'" + string.substring(n + 1);
            n = string.indexOf("'", n + 2);
        }
        return string;
    }

    protected String getDeleteString(String string, Attribute[] attributeArray, Object[] objectArray) {
        return this.getDeleteString(string, this.getStringOfAndedAttributesAndValues(attributeArray, objectArray));
    }

    protected String getDeleteString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("delete from ");
        stringBuffer.append(string);
        if (!string2.equals("")) {
            stringBuffer.append(" where ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected String getInsertString(String string, Attribute[] attributeArray, Hashtable<String, Object> hashtable, Attribute[] attributeArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("insert into ");
        stringBuffer.append(string);
        stringBuffer.append(" (");
        stringBuffer.append(this.getStringOfAttributes(attributeArray));
        stringBuffer.append(") values (");
        stringBuffer.append(this.getStringOfValues(attributeArray, hashtable));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected String getSelectString(String string, Attribute[] attributeArray) {
        return this.getSelectString(string, attributeArray, null, null);
    }

    protected String getSelectString(String string, Attribute[] attributeArray, String string2) {
        return this.getSelectString(string, attributeArray, string2, null);
    }

    protected String getSelectString(String string, Attribute[] attributeArray, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        stringBuffer.append(this.getStringOfAttributes(attributeArray));
        stringBuffer.append(" from ");
        stringBuffer.append(string);
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append(" where ");
            stringBuffer.append(string2);
        }
        if (string3 != null && !string3.equals("")) {
            stringBuffer.append(" order by ");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    protected String getSelectStringWithPrimaryKey(String string, Attribute[] attributeArray, Attribute[] attributeArray2, Object[] objectArray) {
        return this.getSelectString(string, attributeArray, this.getStringOfAndedAttributesAndValues(attributeArray2, objectArray));
    }

    protected String getStringOfAndedAttributesAndValues(Attribute[] attributeArray, Hashtable<String, Object> hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(this.getStringOfAttributeAndValue(attributeArray[i], hashtable.get(attributeArray[i].getName())));
        }
        return stringBuffer.toString();
    }

    protected String getStringOfAndedAttributesAndValues(Attribute[] attributeArray, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" and ");
            }
            stringBuffer.append(this.getStringOfAttributeAndValue(attributeArray[i], objectArray[i]));
        }
        return stringBuffer.toString();
    }

    protected String getStringOfAttributeAndValue(Attribute attribute, Object object) {
        return attribute.getName() + "=" + this.getStringOfValue(attribute, object);
    }

    protected String getStringOfAttributes(Attribute[] attributeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(attributeArray[i].getName());
        }
        return stringBuffer.toString();
    }

    protected String getStringOfAttributesAndValues(Attribute[] attributeArray, Hashtable<String, Object> hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getStringOfAttributeAndValue(attributeArray[i], hashtable.get(attributeArray[i].getName())));
        }
        return stringBuffer.toString();
    }

    protected String getStringOfAttributesAndValues(Attribute[] attributeArray, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getStringOfAttributeAndValue(attributeArray[i], objectArray[i]));
        }
        return stringBuffer.toString();
    }

    protected String getStringOfAttributesAndValuesExceptPrimaryKey(Attribute[] attributeArray, Hashtable<String, Object> hashtable, Attribute[] attributeArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < attributeArray.length; ++i) {
            int n;
            for (n = 0; n < attributeArray2.length && !attributeArray[i].getName().equals(attributeArray2[n].getName()); ++n) {
            }
            if (n < attributeArray2.length) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getStringOfAttributeAndValue(attributeArray[i], hashtable.get(attributeArray[i].getName())));
        }
        return stringBuffer.toString();
    }

    protected String getStringOfValue(Attribute attribute, Object object) {
        if (object == null) {
            return "NULL";
        }
        String string = object instanceof byte[] ? new String((byte[])object) : object.toString();
        switch (attribute.getType()) {
            case 1: 
            case 2: {
                return string;
            }
            case 3: {
                return "'" + this.convertStringForDB(string) + "'";
            }
        }
        throw new IllegalStateException("Unknown attribute type");
    }

    protected String getStringOfValues(Attribute[] attributeArray, Hashtable<String, Object> hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < attributeArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getStringOfValue(attributeArray[i], hashtable.get(attributeArray[i].getName())));
        }
        return stringBuffer.toString();
    }

    protected String getUpdateString(String string, Attribute[] attributeArray, Hashtable<String, Object> hashtable, Attribute[] attributeArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("update ");
        stringBuffer.append(string);
        stringBuffer.append(" set ");
        stringBuffer.append(this.getStringOfAttributesAndValuesExceptPrimaryKey(attributeArray, hashtable, attributeArray2));
        String string2 = this.getStringOfAndedAttributesAndValues(attributeArray2, hashtable);
        if (!string2.equals("")) {
            stringBuffer.append(" where ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected void setUniquePrimaryKeyValueAfterInsert(Connection connection, Entity entity, Hashtable<String, Object> hashtable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUniquePrimaryKeyValueBeforeInsert(Connection connection, Entity entity, Hashtable<String, Object> hashtable) throws SQLException {
        Attribute[] attributeArray = entity.getPrimaryKey();
        Class<?> clazz = entity.getClass();
        synchronized (clazz) {
            for (int i = 0; i < attributeArray.length; ++i) {
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("select max(");
                    stringBuffer.append(attributeArray[i].getName());
                    stringBuffer.append(") from ");
                    stringBuffer.append(entity.getTableName());
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    if (!resultSet.next()) continue;
                    entity.setValue(attributeArray[i].getName(), new Integer(resultSet.getInt(1) + 1));
                    continue;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
            }
        }
    }
}

