/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.simulator;

import de.renew.database.TransactionSource;
import de.renew.engine.common.SimulatorEventLogger;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.events.TransitionException;
import de.renew.engine.searcher.EarlyExecutable;
import de.renew.engine.searcher.Executable;
import de.renew.engine.searcher.LateExecutable;
import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.OccurrenceDescription;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.VariableMapperCopier;
import de.renew.engine.simulator.BindingList;
import de.renew.engine.simulator.PhaseComparator;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.unify.Copier;
import de.renew.unify.Impossible;
import de.renew.util.Detacher;
import de.renew.util.LockComparator;
import de.renew.util.Semaphor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class Binding
implements Runnable {
    public static Logger logger = Logger.getLogger(Binding.class);
    private ArrayList<EarlyExecutable> earlyExecutables;
    private ArrayList<LateExecutable> lateExecutables;
    private OccurrenceDescription[] occurrenceDescriptions;
    private String description;
    private boolean result = false;
    private Semaphor sem = new Semaphor();
    private StepIdentifier stepIdentifier = null;

    Binding(Searcher searcher) {
        Copier copier = new Copier();
        VariableMapperCopier variableMapperCopier = new VariableMapperCopier(copier);
        ArrayList<Executable> arrayList = new ArrayList<Executable>();
        Collection<Occurrence> collection = searcher.getOccurrences();
        for (Occurrence object2 : collection) {
            arrayList.addAll(object2.makeExecutables(variableMapperCopier));
        }
        this.earlyExecutables = new ArrayList();
        this.lateExecutables = new ArrayList();
        for (Executable executable : arrayList) {
            if (executable instanceof EarlyExecutable) {
                this.earlyExecutables.add((EarlyExecutable)executable);
                continue;
            }
            if (executable instanceof LateExecutable) {
                this.lateExecutables.add((LateExecutable)executable);
                continue;
            }
            throw new RuntimeException("Unknown type of executable detected: " + executable);
        }
        int n = collection.size();
        this.occurrenceDescriptions = new OccurrenceDescription[n];
        Iterator<Occurrence> iterator = collection.iterator();
        for (int i = 0; i < n; ++i) {
            Occurrence occurrence = iterator.next();
            this.occurrenceDescriptions[i] = occurrence.makeOccurrenceDescription(variableMapperCopier);
        }
    }

    private String makeText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.occurrenceDescriptions.length; ++i) {
            if (i > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.occurrenceDescriptions[i].getDescription());
        }
        return stringBuffer.toString();
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.makeText();
        }
        return this.description;
    }

    public synchronized boolean execute(StepIdentifier stepIdentifier, boolean bl) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        if (this.earlyExecutables == null) {
            throw new RuntimeException("Cannot execute binding twice.");
        }
        this.stepIdentifier = stepIdentifier;
        if (bl) {
            SimulationThreadPool.getCurrent().execute(this);
        } else {
            SimulationThreadPool.getCurrent().executeAndWait(this);
        }
        SimulatorEventLogger.log(stepIdentifier, "-------- Synchronously --------");
        this.sem.P();
        return this.result;
    }

    private void lock() {
        for (EarlyExecutable earlyExecutable : this.earlyExecutables) {
            earlyExecutable.lock();
        }
    }

    private void unlock() {
        for (EarlyExecutable earlyExecutable : this.earlyExecutables) {
            earlyExecutable.unlock();
        }
    }

    private boolean verify(StepIdentifier stepIdentifier) {
        ArrayList<EarlyExecutable> arrayList = new ArrayList<EarlyExecutable>();
        try {
            for (EarlyExecutable earlyExecutable : this.earlyExecutables) {
                earlyExecutable.verify(stepIdentifier);
                arrayList.add(earlyExecutable);
            }
        }
        catch (Impossible impossible) {
            TransactionSource.rollback();
            Collections.reverse(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((EarlyExecutable)iterator.next()).rollback();
            }
            return false;
        }
        return true;
    }

    private void executeEarly(StepIdentifier stepIdentifier) {
        for (EarlyExecutable earlyExecutable : this.earlyExecutables) {
            earlyExecutable.execute(stepIdentifier);
        }
    }

    private void executeLate(StepIdentifier stepIdentifier) {
        Throwable throwable = null;
        for (LateExecutable lateExecutable : this.lateExecutables) {
            if (lateExecutable.isLong()) {
                Detacher.detach();
            }
            try {
                if (throwable == null) {
                    lateExecutable.execute(stepIdentifier);
                    continue;
                }
                lateExecutable.executeAfterException(stepIdentifier, throwable);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    SimulatorEventLogger.log(stepIdentifier, new TransitionException(throwable2));
                } else {
                    SimulatorEventLogger.log(stepIdentifier, new TransitionException(throwable2));
                }
                logger.error((Object)throwable2.getMessage(), throwable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        BindingList.register(this);
        TransactionSource.start();
        Collections.sort(this.earlyExecutables, new LockComparator());
        this.lock();
        try {
            Collections.sort(this.earlyExecutables, new PhaseComparator());
            this.result = this.verify(this.stepIdentifier);
            if (this.result) {
                this.executeEarly(this.stepIdentifier);
            }
        }
        finally {
            this.unlock();
        }
        this.sem.V();
        if (this.result) {
            Collections.sort(this.lateExecutables, new PhaseComparator());
            this.executeLate(this.stepIdentifier);
            try {
                TransactionSource.commit();
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        BindingList.remove(this);
        this.earlyExecutables = null;
        this.lateExecutables = null;
    }
}

